// This may look like C code, but it is really -*- C++ -*-
//  Classe PPFNameTag  - R. Ansari - Nov 2003
//  To ease manipulation of nametags in PPF streams 

#ifndef PPFNAMETAG_H_SEEN
#define PPFNAMETAG_H_SEEN

#include "ppersist.h"

//----------------------------------------------------------------------
namespace SOPHYA {
//! A simple class to ease manipulation of nametags in PPF streams

class PPFNameTag {
public:
  PPFNameTag(string const & tn) { _tname = tn; }
  PPFNameTag(const char * tn) { _tname = tn; }
  ~PPFNameTag() { } 
  inline bool GotoNameTag(PInPersist& pi) 
  { return pi.GotoNameTag(_tname); }
  inline void WriteTag(POutPersist& po) 
  { return po.WriteNameTag(_tname); }
  inline char*  operator= (char* s) { _tname = s; }
  inline string& operator= (string const & s)  { _tname = s; } 
  inline operator  string() const { return _tname; }
protected:
  string _tname; 
};

inline PInPersist& operator >> (PInPersist& si, PPFNameTag & pnt) 
{ pnt.GotoNameTag(si); return(si); }

inline POutPersist& operator >> (POutPersist& so, PPFNameTag & pnt) 
{ return pnt.WriteTag(so); return(so); }

}  // namespace SOPHYA

#endif   /* PPFNAMETAG_H_SEEN */
