#ifndef NDATABLOCK_H
#define NDATABLOCK_H

#include "machdefs.h"

// Classe pour permettre de partager des donnees avec 
// un autre systeme de gestion de references (ex avec Blitz)
class Bridge {
public:
  Bridge() { } 
  virtual ~Bridge() { }
};

// classe de container avec partage de reference
template <class T>
class NDataBlock {

public:

  // Creation / destruction 
  NDataBlock(size_t n);
  NDataBlock(size_t n, T* data, Bridge* br=NULL);
  NDataBlock();
  NDataBlock(NDataBlock<T>& a);
  NDataBlock(NDataBlock<T>& a,bool share);
  virtual ~NDataBlock();

  // Temporaire?
  inline bool IsTemp(void)       {return mIsTemp;}
  inline void SetTemp(bool temp) {mIsTemp=temp;}

  // Gestion taille
  void Clone(NDataBlock<T>& a);
  void ReSize(size_t n);
  
  // Informations pointeur/data
  inline T* Data()
         {if(mSRef) return mSRef->data; else return NULL;}
  inline size_t  Size() const    {return mSz;}
  inline T& operator()(size_t i) {return mSRef->data+i;}

  inline T*        Begin()        {return mSRef->data;}
  inline T const*  Begin() const  {return mSRef->data;}
  inline T*        End()          {return mSRef->data+mSz;}
  inline T const*  End() const    {return mSRef->data+mSz;}

  // Impression
  void Print(size_t i1=0,size_t n=0);

  // Surcharge d operateurs
  NDataBlock<T>& operator = (const NDataBlock<T>& a);
  NDataBlock<T>& operator = (T v);

  NDataBlock<T>& operator += (T b);
  NDataBlock<T>& operator -= (T b);
  NDataBlock<T>& operator *= (T b);
  NDataBlock<T>& operator /= (T b);

  NDataBlock<T>& operator += (const NDataBlock<T>& a);
  NDataBlock<T>& operator -= (const NDataBlock<T>& a);
  NDataBlock<T>& operator *= (const NDataBlock<T>& a);
  NDataBlock<T>& operator /= (const NDataBlock<T>& a);


protected:

  typedef struct {size_t nref; T* data; Bridge* bridge; } NDREF;

  void Alloc(size_t n,T* data=NULL,Bridge* br=NULL);
  void Share(NDataBlock<T>& a);
  void Delete(void);

  size_t   mSz;
  NDREF*   mSRef;
  bool     mIsTemp;
};


template<class T> NDataBlock<T> operator + (const NDataBlock<T>& a, T b);
template<class T> NDataBlock<T> operator + (T b,const NDataBlock<T>& a);
template<class T> NDataBlock<T> operator - (const NDataBlock<T>& a, T b);
template<class T> NDataBlock<T> operator - (T b,const NDataBlock<T>& a);
template<class T> NDataBlock<T> operator * (const NDataBlock<T>& a, T b);
template<class T> NDataBlock<T> operator * (T b, const NDataBlock<T>& a);
template<class T> NDataBlock<T> operator / (const NDataBlock<T>& a, T b);

template<class T> NDataBlock<T> operator + (const NDataBlock<T>& a, const NDataBlock<T>& b);
template<class T> NDataBlock<T> operator - (const NDataBlock<T>& a, const NDataBlock<T>& b);
template<class T> NDataBlock<T> operator * (const NDataBlock<T>& a, const NDataBlock<T>& b);
template<class T> NDataBlock<T> operator / (const NDataBlock<T>& a, const NDataBlock<T>& b);

#endif
