// This may look like C code, but it is really -*- C++ -*-
// Classe interpreteur de commande pour piapp 
// Reza      Aout 97 , Juillet,Aout 98
//           Octobre 2003: de PIext -> SysTools
// LAL-IN2P3/CNRS  DAPNIA/CEA

#ifndef COMMANDER_H_SEEN
#define COMMANDER_H_SEEN

#include "machdefs.h"
#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <list>
#include <stack>
#include <map>
#include <functional>

#include "pdlmgr.h"
#include "dvlist.h"
#include "ctimer.h"

// Classe definissant l'interface pour un executeur de commande

// Classe definissant l'interface pour un interpreteur de commande

//! Interface definition for a generic command interpreter
class CmdInterpreter {
public:
  virtual		~CmdInterpreter() {} ;
  virtual string	Name()=0;
  virtual int		Interpret(string& line)=0;
};


//! Interface definition for command executor, to be used with SOPHYA::Commander

class CmdExecutor {
public:
  virtual	~CmdExecutor() {} ;
  // keyw : Le mot cle associe , args: Arguments de la commande
  virtual int	Execute(string& keyw, vector<string>& args, string& toks)=0;
};



class CommanderBloc;    // Bloc de type foreach / for de l'interpreteur Commander
class CommanderScript;  // Script de commandes defini ds l'interpreteur Commander

/*
//! Interface definition for SOPHYA::Commander help manager
class CommanderHelpMgr {
public :
			CommanderHelpMgr();
  virtual		~CommanderHelpMgr();
  virtual void		AddHelpGroup(const char * hgrp, int gid);
  virtual void		AddHelpItem(const char * hitem);
  virtual void          ClearHelpList();
  virtual void		Activate();
}
*/


//! A simple command interpreter with c-shell like syntax with dynamic load capability.

class Commander : public CmdInterpreter  {
public:
  static Commander*	GetInterpreter();

			Commander();
  virtual		~Commander();
  virtual string	Name();

  virtual void		AddHelpGroup(string& grp, string& desc);
  virtual void		RegisterCommand(string& keyw, string& usage, CmdExecutor * ce, 
                                        string& grp);
  inline  void		RegisterCommand(string& keyw, string& usage, CmdExecutor * ce, 
                                        char* grp)
                        { string sgrp = grp; RegisterCommand(keyw, usage, ce, sgrp); }

  virtual void		RegisterHelp(string& keyw, string& usage, string& grp);

  virtual void		LoadModule(string& fnameso, string& name);

  virtual void		AddInterpreter(CmdInterpreter * cl);
  virtual void		SelInterpreter(string& name);

  virtual int		Interpret(string& line);

  virtual int		ExecuteCommand(string& keyw, vector<string>& args, string& toks);
  virtual int		ExecFile(string& file, vector<string>& args);
  virtual int		CShellExecute(string cmd);
  virtual string&	GetUsage(const string& kw);

  inline  void		SetMaxLoopLimit(int_8 lim=0) { maxlooplimit = lim; }
  inline  int_8         GetMaxLoopLimit() { return maxlooplimit; }

  string		GetCurrentPrompt() { return curprompt; }


  virtual void 		HelptoLaTeX(string const & flnm);

  inline  CmdInterpreter* CurrentInterpreter() { return(curcmdi); }


//   Utilitaire pour decoupage en mot
  static  int   LineToWords(string& line, string& kw, vector<string>& tokens,
			    string& toks, bool uq=true);
protected:
  virtual int	ParseLineExecute(string& line, bool qw=true);

  virtual int   ExecuteCommandLine(string & keyw, vector<string> & args,
				   string & toks);

  virtual bool	CheckHelpGrp(string& grp, int& gid, string& desc);
  inline  bool	CheckHelpGrp(string& grp, int& gid)
  { string desc=""; return CheckHelpGrp(grp, gid, desc); }

  virtual int   SubstituteVars(string & s, string & s2);  
  int	        EvaluateTest(vector<string> & args, 
			     string & line, bool & res);
  int	        EvalRPNExpr(vector<string> & args, string & line);

  virtual bool    GetVar(string & vn, string & vv);
  virtual string  GetVariable(string const & vn);
  virtual bool    HasVariable(string const & vn);
  virtual bool    SetVar(string const & vn, string const & vv);
  virtual bool    DeleteVar(string const & vn);
  virtual void    ListVars();

  virtual string  GetTmpDir();

  virtual void  SetCurrentPrompt(const char* pr);
  inline void   SetCurrentPrompt(string const & pr) { SetCurrentPrompt(pr.c_str()); }

  virtual void	ShowMessage(const char * msg, int att);

  void          PushStack(vector<string> & args);
  void          PopStack(bool psta=true);

  CmdInterpreter* curcmdi;

// Gestion des variables
  DVList variables;

// Pour enregistrer la liste de commandes et leurs executeurs et le help
  struct cmdex {int group; string us; CmdExecutor * cex; } ;
  struct hgrpst {int gid; string desc; } ;               // Identification+description d'un groupe de help
  typedef map<string, hgrpst, less<string> > CmdHGroup;   // Liste des groupes de commandes
  CmdHGroup cmdhgrp;
  int cmdgrpid;                                        // Numero de groupe courant
  typedef map<string, cmdex, less<string> > CmdExmap;  
  CmdExmap cmdexmap;                                   // Liste des commandes et leurs executeurs
  CmdExmap helpexmap;                                  // Pour les helps sans commande

// Pour garder la liste des modules 
  typedef map<string, PDynLinkMgr* , less<string> > Modmap;
  Modmap modmap;

// Pour garder la liste des interpreteur
  typedef map<string, CmdInterpreter*, less<string> > InterpMap;
  InterpMap interpmap;
 
//  Pour stocker les scripts definis ds l'interpreteur
  typedef map<string, CommanderScript*, less<string> > ScriptList;
  ScriptList mScripts;  // Liste des scripts
  CommanderScript* curscript; // Script en cours de definition

//  Pour stocker les alias definies par l'interpreteur
  typedef map<string, string, less<string> > CmdStrList;
  CmdStrList mAliases;  // Liste des alias 

// Le stack pour les arguments des .pic et des scripts
  stack< vector<string> > ArgsStack;
// Stack pour les Prompts
  stack<string> PromptStack; 

  stack< CommanderBloc * > CmdBlks;  // Bloc de commande courant (foreach, ...)
  int felevel;                    // foreach-for level 
  int_8 maxlooplimit;            // Limite maximum des boucles
  stack< list<char> > TestsStack; // Stack des resultats de test
  list<char>::iterator tresit;       // Test courant
  bool curtestresult;             // Resultat courant des tests 

  bool mulinefg;            // Bloc multi-lignes (ligne suite)
  string mulinecmd;         // Commande multi-lignes
  string spromptmul;        // Prompt console avant multi-ligne
  string curprompt;

  ofstream hist;       //  History file 
  bool histon;        //  True ->  history file
  bool trace;          // Trace flag
  bool timing;         // Display CPU Time
  Timer* gltimer;      // pour Display CPU Time

};


/* end of ifdef COMMANDER_H_SEEN */
#endif  

