#include "sophyainit.h"
#include "array.h"
#include "fiondblock.h"
#include "fioarr.h"
#include "tarrinit.h"


int main(int narg, char* arg[])
{

cout << " ------------------------------------------------ " << endl;
cout << " ---------- Start of ppftswap program ----------- " << endl;

try {
  SophyaInit();
  // Phase d'ecriture - remplissage de fichier PPF 
  cout << ">>>> Create/Write PPF stream  ppfts.ppf " << endl;
  {  
#define DSZ_SWT  8
    // Vecteur pour garder les positions des tableaux ecrits 
    TVector<int_8> sw_fpos(10, BaseArray::RowVector);
    vector<int_8> swsvfp;
    // Tableau pour les donnees a ecrire (en mode swap)
    // ds le flot PPersist
    NDataBlock<int_4> sw_data(DSZ_SWT);
    // Objets divers a ecrire dans le meme flot 
    NDataBlock<int_4> idb(16);
    idb = 16;
    NDataBlock<r_4> fdb(7);
    fdb = 4.5;
    TVector<int_4> iv(7, BaseArray::RowVector);
    iv = RegularSequence(5.,3.);
    TMatrix<r_4> mx(3,5);
    mx = RegularSequence(0.14,0.2);
    // -------------------------------------------------------------
    // Generation de donnees et ecriture (pour lecture en mode swap)
    // -------------------------------------------------------------
    POutPersist so("ppfts.ppf");
    cout << " Writing data for testing swap ... " << endl;
    for(int i=0; i<sw_fpos.Size(); i++) {
      for(int j=0; j<sw_data.Size(); j++) sw_data(j) = i*100+j;
      // Ecriture de tag de positionnement
      sw_fpos(i) = so.WritePositionTag();
      swsvfp.push_back(sw_fpos(i));

      // Ecriture de donnees correspondantes
      // Il vaut mieux ne pas utiliser un objet a ce stade
      so.PutI4s(sw_data.Data(), sw_data.Size());
      cout << "[" << i << "] Written data (Pos=" << sw_fpos(i) 
	   << ") : " << sw_data << endl;
    }
    // On ecrit d'autres objets 
    cout << " Writing DataBlock idb= \n" << idb << endl;
    so << idb;
    cout << " Writing Vector iv" << iv << endl;
    so << iv;
    cout << " Writing DataBlock fdb with TagName FDB : \n" << fdb << endl;
    so << PPFNameTag("FDB") << fdb;
    cout << " Writing Matrix mtx with TagName MTX " << mx << endl;
    so << PPFNameTag("MTX") << mx;
    // On ecrit finalement Les Positions Tag
    string posttable="PosTagTable";
    so.WriteNameTag(posttable);
    // Ecriture de la table des PositionTags
    // C'est cette methode qui doit etre utilisee en principe
    so.PutPosTagTable(swsvfp);
    // On ecrit aussi le TVecteur sw_fpos
    so.PutObject(sw_fpos);
    
  }
  
  // Phase de relecture 
  cout << ">>>> Reading objects from PPF stream  ppfts.ppf " << endl;
  {
    TVector<int_8> sw_fpos;
    vector<int_8> swsvfp;
    NDataBlock<int_4> sw_data(DSZ_SWT);
    NDataBlock<int_4> idb;
    NDataBlock<r_4> fdb;
    TVector<int_4> iv;
    TMatrix<r_4> mx;

    PInPersist si("ppfts.ppf");
    si >> idb;
    cout << " Read-OK DataBlock idb= \n" << idb << endl;
    si.GetObject(iv);
    cout << " Read-OK Vector iv= " << iv << endl;
    si >> PPFNameTag("MTX") >> mx;
    cout << " Read-OK Matrix mx= " << mx << endl;
    string tname = "FDB";
    si.GotoNameTag(tname);
    si >> fdb;
    cout << " Read-OK DataBlock fdb at tag FDB : \n" << fdb << endl;
    cout << " --- Reading PositionTagTable ... " << endl;
    si >> PPFNameTag("PosTagTable");
    si >> sw_fpos;
    cout << " Read-OK sw_fpos= " << sw_fpos << endl;
    for(int i=0; i<sw_fpos.Size(); i++) {
      // On se positionne 
      si.GotoPositionTag(sw_fpos(i));
      // On lit le tableau
      si.GetI4s(sw_data.Data(), sw_data.Size());
      cout << "[" << i << "] Read data (Pos=" << sw_fpos(i) 
	   << ") : " << sw_data << endl;
    }
    // On lit quand meme le PosTagTable pour verification 
    cout << " Reading the PositionTagTable .... " << endl;
    si >> PPFNameTag("PosTagTable");
    si.GetPosTagTable(swsvfp); 
    for(int k=0; k<swsvfp.size(); k++)  
      cout << swsvfp[k] << "  ";
    cout << endl;
  }
  
}
catch (PThrowable & exc) {
  cerr << " ppftswap/Catched Exception " << (string)typeid(exc).name() 
       << " - Msg= " << exc.Msg() << endl;
}
catch (...) {
  cerr << " ppftswap/some other exception was caught ! " << endl;
}

 cout << " ----------- End of ppftswap program ------------ " << endl;
 cout << " ------------------------------------------------ " << endl;

}

