// This may look like C code, but it is really -*- C++ -*-
//  Classe PPFNameTag  - R. Ansari - Nov 2003
//  To ease manipulation of nametags in PPF streams 

#ifndef PPFNAMETAG_H_SEEN
#define PPFNAMETAG_H_SEEN

#include "ppersist.h"

//----------------------------------------------------------------------
namespace SOPHYA {
//! A simple class to ease manipulation of nametags in PPF streams

class PPFNameTag {
public:
  PPFNameTag(PPFNameTag const & ptn) { _tname = ptn._tname; }
  PPFNameTag(string const & tn) { _tname = tn; }
  PPFNameTag(const char * tn) { _tname = tn; }
  ~PPFNameTag() { } 
  inline bool GotoNameTag(PInPersist& pi) const
  { return pi.GotoNameTag(_tname); }
  inline void WriteTag(POutPersist& po) const
  { return po.WriteNameTag(_tname); }
  inline char*  operator= (char* s) { _tname = s; return s; }
  inline string const & operator= (string const & s)  { _tname = s; return s; } 
  inline operator  string() const { return _tname; }
protected:
  string _tname; 
};

inline PInPersist& operator >> (PInPersist& si, PPFNameTag const & pnt) 
{ pnt.GotoNameTag(si); return(si); }

inline POutPersist& operator << (POutPersist& so, PPFNameTag const & pnt) 
{ pnt.WriteTag(so); return(so); }

}  // namespace SOPHYA

#endif   /* PPFNAMETAG_H_SEEN */
