// This may look like C code, but it is really -*- C++ -*-
// Interface C++ aux Thread POSIX  -   R. Ansari 02/2001
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef ZTHREAD_SEEN
#define ZTHREAD_SEEN

#include "machdefs.h"
#include <pthread.h>
#include "pexceptions.h"


namespace SOPHYA {

typedef void (* ZThreadAction) (void *);

/*!
  \class SOPHYA::ZThreadExc
  \ingroup SysTools
  This exception class is used by the classes implementing the interface 
  to the POSIX threads (\b ZThread ...)
*/  
class ZThreadExc : public PException {
public:
  explicit ZThreadExc(const string& m, int id=0) : PException(m,id) {}
};

class ZThread {
public:
  explicit	ZThread(size_t stacksize=0);
  virtual	~ZThread();
  void		start();
  void		cancel();
  inline void   stop() { cancel(); }

  void          join();
  virtual void  run();

  //! Sets the return code for the thread object
  inline void   setRC(int rc) { _rc = rc; }
  //! Return the value of the return code for the thread object
  inline int    getRC(int rc) { return(_rc);
 }
  inline void	setAction(ZThreadAction act, void * usp=NULL)
       {  _act = act;  _usp = usp; }


  static inline void setCancelState(int st= PTHREAD_CANCEL_ENABLE) 
       { int ocs; pthread_setcancelstate(st, &ocs); }
  // PTHREAD_CANCEL_ENABLE  ou PTHREAD_CANCEL_DISABLE
  static inline void setCancelType(int ct= PTHREAD_CANCEL_DEFERRED) 
       { int oct; pthread_setcanceltype(ct, &oct); }
  // PTHREAD_CANCEL_DEFERRED  ou  PTHREAD_CANCEL_ASYNCHRONOUS


  // ---- Attribute variables ----
  pthread_t _thr;
  size_t _ssize;
  int _rc;
  bool _initok;

  ZThreadAction _act;
  void * _usp;
};


class ZMutex {
public:
  explicit	ZMutex();
  virtual	~ZMutex();
  //! Locks the mutex object
  inline void	lock()
    { pthread_mutex_lock(_mutx); } 
  //! Unlocks the mutex object
  inline void	unlock()
    { pthread_mutex_unlock(_mutx); }
  //! Waits for a condition change
  inline void	wait()
    { pthread_cond_wait(_condv, _mutx); }
  //! Signal a condition change on the mutex object
  inline void	signal()
  { pthread_cond_signal(_condv); }
  //! Broadcasts a condition change on the mutex object
  inline void	broadcast()
  { pthread_cond_broadcast(_condv); }

  // Attributes
  pthread_mutex_t * _mutx;
  pthread_cond_t * _condv;
};


class ZSync {
public:
  explicit inline  ZSync(ZMutex & mtx, int sigbr=0) 
  {_mtx = &mtx; _sigbr = sigbr; mtx.lock(); }
  inline	   ~ZSync() 
  { 
    if (_mtx) { 
      _mtx->unlock(); 
      if (_sigbr == 1) _mtx->signal(); 
      else  if (_sigbr == 2) _mtx->broadcast(); 
    }
  }

private:
  ZMutex * _mtx;
  int _sigbr;
  inline	ZSync() {_mtx = NULL; _sigbr = 0; }

};

} // namespace SOPHYA

#endif
