//
// $Id: simplesort.cc,v 1.3 2004-03-15 16:46:56 ansari Exp $
//

#include "machdefs.h"
#include "simplesort.h"
#include <stdlib.h>

//++
// Class	SimpleSort
// Lib  	Outils++ 
// include	simplesort.h
//
//	Classe pour trier. Utiliser plutt la STL.
//--


SimpleSort::SimpleSort(int nElts)
: numElts(nElts), index(new TRIPAIRE[nElts])
{
}
			
SimpleSort::~SimpleSort()
{
  delete[] index;
}

int SimpleSort::Compare(const void* tp1, const void* tp2)
{ float x=((TRIPAIRE*)tp1)->value - ((TRIPAIRE*)tp2)->value;
  if (x>0) return(1);
  else if (x<0) return(-1);
  else return(0);
}

#if !ARG_FUNC_CPP_C
extern "C" int SimpleSortCompare(const void* tp1, const void* tp2);

int SimpleSortCompare(const void* tp1, const void* tp2)
{ return SimpleSort::Compare(tp1, tp2);
}
#endif

void SimpleSort::Sort()
{
#if ARG_FUNC_CPP_C
  qsort(index, numElts, sizeof(TRIPAIRE), SimpleSort::Compare);
#else
  qsort(index, numElts, sizeof(TRIPAIRE), SimpleSortCompare);
#endif
}

int SimpleSort::Lookup(float val)
{
  int a = 0;
  int b = numElts-1;
  while (b>a+1) {
    int c = (b+a)/2;
    ((val >= index[c].value) ? a : b) = c;
  }
  return a;
}
