// This may look like C code, but it is really -*- C++ -*-
#ifndef PEXCEPTIONS_SEEN
#define PEXCEPTIONS_SEEN

#include "machdefs.h"
//#include <exception>
#include <string>

using namespace std;

namespace PlanckDPC {

  // Ancestor for PError and PException
  class PThrowable { // : public exception {
	public:
		explicit PThrowable(const string& m) : msg(m) {}
                virtual ~PThrowable() { }
		virtual string const& Msg() const  {return msg;}
	private:
		string msg;
  };

  // A PError is a serious logic error. Usually not caught...
  class PError : public PThrowable {
	public:
        explicit PError(const string& m) : PThrowable(m) {}
  };
  
  // A PException is not as serious... Can be caught.
  class PException : public PThrowable {
	public:
        explicit PException(const string& m) : PThrowable(m) {}
  };

  // Errors
  class AllocationError : public PError {
    public:
        explicit AllocationError(const string& m) : PError(m) {}
  };
  
  class NullPtrError : public PError {
    public:
        explicit NullPtrError(const string& m) : PError(m) {}
  };

  class SzMismatchError : public PError {
    public:
        explicit SzMismatchError(const string& m) : PError(m) {}
  };

  class RangeCheckError : public PError {
    public:
        explicit RangeCheckError(const string& m) : PError(m) {}
  };

  class ParmError : public PError {
    public:
        explicit ParmError(const string& m) : PError(m) {}
  };

  class ForbiddenError : public PError {
    public:
        explicit ForbiddenError(const string& m) : PError(m) {}
  };

  class AssertionFailedError : public PError {
    public:
        explicit AssertionFailedError(const string& m) : PError(m) {}
  };

  // Standard exceptions
  class TypeMismatchExc : public PException {
    public:
        explicit TypeMismatchExc(const string& m) : PException(m) {}
  };

  class FileExc : public PException {
    public:
        explicit FileExc(const string& m) : PException(m) {}
  };

  class FileFormatExc : public PException {
    public:
        explicit FileFormatExc(const string& m) : PException(m) {}
  };

  class DuplicateIdExc : public PException {
    public:
        explicit DuplicateIdExc(const string& m) : PException(m) {}
  };

  class NotFoundExc : public PException {
    public:
        explicit NotFoundExc(const string& m) : PException(m) {}
  };

  class CaughtSignalExc : public PException {
    public:
        explicit CaughtSignalExc(const string& m) : PException(m) {}
  };
  
  class SingMatrixExc : public PException {
    public:
        explicit SingMatrixExc(const string& m) : PException(m) {}
  };
  

}


#define ASSERT(_a_) if (!(_a_)) { \
     cerr << "Assertion failed " #_a_ " file " __FILE__ " line " << __LINE__ \
          << endl; \
		     throw(AssertionFailedError(#_a_)); }
   
#define FAILNIL(_x_) \
       {if (!(_x_)) throw(NullPtrError(#_x_))}

void InitFailNewHandler();
  
     
// Compatibility with EROS-PEIDA exceptions

#define EXC_ABORT_NEG(_x)
#define EXC_ABORT_ALL(_x)

#define EXC_AWARE

#define END_CONSTRUCTOR

#define TRY try
#define CATCH(_var) catch(long _var)
#define CATCHALL catch(...)
#define ENDTRY

#define THROW(_i) throw( _i);

#define THROW_ THROW(0)

#define THROW_SAME throw;

#define RETURN(x) return(x)
#define RETURN_ return

#define rangeCheckErr    RangeCheckError("")
#define typeMismatchErr  TypeMismatchExc("")
#define allocationErr    AllocationError("")
#define parmErr          ParmError("")
#define inconsistentErr  ParmError("")
#define sizeMismatchErr  SzMismatchError("")
#define fileErr          FileExc("")
#define nullPtrErr       NullPtrError("")
#define singMatxErr      SingMatrixExc("")

#define DBASSERT(_x_) ASSERT(_x_)

#endif
