// This may look like C code, but it is really -*- C++ -*-
// Evaluateur d'expression C   -   R. Ansari 03/2004
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef CEXPREVAL_SEEN
#define CEXPREVAL_SEEN

#include "machdefs.h"
#include <iostream>
#include <string>
#include "pexceptions.h"

using namespace std;
namespace SOPHYA {

//! Exception class used by  CExpressionEvaluator
class CExprException : PException {
  public:
  explicit CExprException(const char * m) : PException(m) {}
  explicit CExprException(const string& m) : PException(m) {}
};

//--------------------------------------------------------------------
//! Base class for arithmetic expressions used by CExpressionEvaluator
class CExprBase {
public:
  explicit CExprBase(); 
  virtual ~CExprBase();
  virtual double Evaluate() const = 0;
  virtual bool   CheckE(string& errmsg) const { return true; }
  virtual void   CheckThrow(const char * msg) const;
  inline  void   CheckThrow(string const & msg) const { CheckThrow(msg.c_str()); }
  virtual void   Print(ostream& os) const = 0;
  static long    NbCreate() { return totnexp_create; }
  static long    NbDelete() { return totnexp_delete; }
protected:
  static long totnexp_create;
  static long totnexp_delete;
};

inline ostream& operator << (ostream& s, CExprBase const & ex)
  {  ex.Print(s);  return(s);  }

class CE_BinExp;
class CE_FuncExp;
//---------------------------------------------------------
//! Class for evaluation of arithmetic expressions with C-like syntax
class CExpressionEvaluator : public CExprBase {
public:
  CExpressionEvaluator(string const & sex);
  virtual ~CExpressionEvaluator();
  virtual double Evaluate() const;
  inline double Value() const { return Evaluate(); }
  virtual void  Print(ostream& os) const;

protected:
  CExprBase* ParseString(int extype, string fname, string const & sex, 
		    size_t off, size_t& stop, string& errmsg);

  CExprBase * _exp;
};

}   // End of namespace SOPHYA

/* end of ifdef CEXPREVAL_SEEN */
#endif
