// This may look like C code, but it is really -*- C++ -*-
// Classe  PI2dVecDrawer  : trace de flow chart 
// (c) DAPNIA (CEA)                 LAL (IN2P3/CNRS)
//                           R. Ansari O.Perdereau  01/2002
//
//=========================================================//

#ifndef PI2DVEC_H_SEEN 
#define PI2DVEC_H_SEEN 
#include "pistdimgapp.h"
#include "piscdrawwdg.h"
#include "ntupintf.h"

class PI2dVecDrawer : public PIDrawer{
public:

  PI2dVecDrawer(NTupleInterface* nti,bool autodel);
  virtual           ~PI2dVecDrawer();
  virtual void      Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);
  virtual void      UpdateLimits();
  virtual int       SelectXY(const char* px, const char* py);
  virtual int       SelectVW(const char* px, const char* py);

// Renvoie une distance au point x,y
  virtual double     GetDistanceToPoint(double x, double y);
 
protected:
  bool _autodel;
  NTupleInterface* _nti;
  
  int xK, yK;            // Index du nom de variable en X/Y ds le ntuple
  int vK, wK;          // Index du nom de variable des longueurs des vecteurs ds le ntuple

};

//
//
//

#endif
