#ifndef PINTUPLE3D_H
#define PINTUPLE3D_H

#include "ntupintf.h"
#include "pi3ddrw.h"

class PINTuple3D : public PIDrawer3D {
public:
                     PINTuple3D(NTupleInterface* nt, bool ad=false);
  virtual           ~PINTuple3D();
  
  virtual void       Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);
  virtual void       UpdateLimits();
  
  virtual void       SelectXYZ(const char* px, const char* py, const char* pz);
  virtual void       SelectWt(const char* pw=NULL);
  virtual void       SelectErrBar(const char* erbx=NULL, const char* erby=NULL, const char* erbz=NULL);
  virtual void       SelectLabel(const char* plabel);

  inline  void       ConnectPoints(bool fg=false) { connectPts = fg; }

  // Gestion de la representation de poids
  inline  void       UseSizeScale(bool fg=true, int nbins=5)
    { mrkSzScale = fg; if (nbins>0) nWbins = nbins; }
  inline  void       UseColorScale(bool fg=true) { colorScale = fg; }

  inline  bool       GetSizeScale(int& nbins) 
    { nbins = nWbins; return mrkSzScale; }
  inline  bool       GetColScale() { return colorScale; }

//   Methode de decodage des options
  virtual int        DecodeOptionString(vector<string> & opt, bool rmdecopt=true);
  virtual int        OptionToString(vector<string> & opt) const;
//   Texte d'aide des options disponibles
  virtual void       GetOptionsHelpInfo(string& info);
       
protected:
  NTupleInterface* mNT;
  bool mAdDO;
  bool mAutoScaleXY, mAutoScaleZ;
  int xK, yK, zK;           // Index du nom de variable en X/Y/Z ds le ntuple
  int xebK, yebK, zebK;     // Index du nom de variable en ErrBarX/Y/Z ds le ntuple
  int wK;                   // Index du nom de variable poids
  int lK;                   // Index du nom de variable label (affiche en texte)
  double wMin, wMax;        // Valeurs de poids min/max
  bool mrkSzScale;     // true -> Taille de markers variable suivant poids
  int nWbins;          // Nombre de bins taille de marker variable
  bool colorScale;     // true -> Couleur de marker variable suivant poids

  bool connectPts;          // true -> les points sont relies par une ligne

};

#endif
