/* #include "machdefs.h" */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <time.h>


/*  ---------------------------------------------------  */
/*  --- Petit programme d'estimation de la puissance CPU */
/*  Compilation: csh> cc -O3 -o cpupower cpupower.c      */
/*  R. Ansari   -   LAL   Mai 2004                       */
/*  ---------------------------------------------------  */

/*  Choix de type d'operations  float double int ... */
#define  T_Type  float 

static int SZ;                    /* Taille de tableau */
static double N_OP;               /* Nb operations */
static  int OPE;                  /* Choix Operation fop_1 ou fop_2 */
static int ckprt;                 /* > 0 : Print check apres calcul */

/*  Tableaux X,Y,Z   */
static T_Type * x;              
static T_Type * y;
static T_Type * z;

void fop_1()
{
  T_Type s;
  int i,j,k;
  printf("--- fop_1: Double Loop: z[k] = Somme_i(x[k]*y[i]) --- \n");
  for(k=0; k<SZ; k++) {
    for(i=0; i<SZ; i++)  s += x[k]*y[i];
    z[k] = s;
    N_OP += 2*SZ;
  }
  return;
}

void fop_2() 
{
  T_Type s;
  int i,j,k;
  printf("--- fop_2: Double Loop: z[k] = Somme_i(x[k]*y[i]+x[i]*y[k]) --- \n");
  for(k=0; k<SZ; k++) {
    for(i=0; i<SZ; i++)  s += x[k]*y[i]+x[i]*y[k];
    z[k] = s;
    N_OP += 4*SZ;
  }
  return;
}

/* Fonctions de timing (TCPU) - voir en fin de fichier */
void InitTim(void);                                                             
void PrtTim(const char * Comm);                                                        
double GetPartialCPUTime();
double GetTotalCPUTime();

int main(int narg, char* arg[])
{
  int maxnprt = 1000;
  int i,nprt;
  double mflops;

  /*  SophyaInit();   */
  InitTim();   /* Initializing the CPU timer  */

  if (narg < 2) {
    printf("--- Programme cpupower: (Puissance de calcul) ---- \n");
    printf("  Usage cpupower Op=1/2 [Size=20000] [CkPrt=0] \n");
    return;
  } 
  OPE = atoi(arg[1]);
  SZ = 20000;
  if (narg > 2)  SZ = atoi(arg[2]);
  ckprt = 0;
  if (narg > 3)  ckprt = atoi(arg[3]);

  printf("::::::: cpupower: OPE=%d SZ= %d ::::::: \n", OPE,SZ);
  x = malloc(SZ*sizeof(T_Type));
  y = malloc(SZ*sizeof(T_Type));
  z = malloc(SZ*sizeof(T_Type));

  for(i=0; i<SZ; i++) {
    x[i] = (T_Type)((random()%10000)-5000);  
    y[i] = (T_Type)((random()%10000)-5000);  
    y[i] = (T_Type)(0);
  }
  PrtTim("--Fin malloc+init x,y,z ");
  if (OPE == 2)  fop_2();
  else fop_1();
  PrtTim("---Fin OpeDoubleBoucle ");
  mflops = N_OP/ GetPartialCPUTime()*1.e-6;
  printf("-> Nb Operations~= %g  MFLOPS~= \n",N_OP,mflops);
  if (ckprt > 0) {
    printf(" CheckPrint - ckprt= %d maxnprt= %d \n", ckprt, maxnprt);
    nprt = 0;
    for(i=0; i<SZ; i+= ckprt) {
      printf("i=%d x[i]=%g y[i]=%g z[i]=%g \n", i, (double)x[i], 
	(double)y[i], (double)z[i]);
      nprt++; 
      if (nprt > 1000) break;
    }
  }

  PrtTim("----Fin cpupower");
  printf(":::::: FIN cpupower N_OP~= %g MFLOPS~= %g ::::::: \n", N_OP,mflops);

  free(x);
  free(y);
  free(z);
}


static clock_t CPUT0, CPUT;
static time_t ELT0, ELT;
static double _totcpu, _partialcpu;

void InitTim(void)
{
CPUT0 = CPUT = clock();
ELT0 = ELT = time(NULL);
_totcpu = _partialcpu = 0.;
return;
}
double GetPartialCPUTime() { return _partialcpu; }
double GetTotalCPUTime() { return _totcpu; }

/* Nouvelle-Fonction */
void PrtTim(const char * Comm)
{
float tcal,tcalt;
clock_t cput;
time_t elt;
int etm,etmt;
 
elt = time(NULL);  cput = clock();
tcalt = ( (float)(cput) - (float)(CPUT0) ) / (float)(CLOCKS_PER_SEC);
tcal = ( (float)(cput) - (float)(CPUT) ) / (float)(CLOCKS_PER_SEC);
_totcpu = tcalt;
_partialcpu = tcal;

etm = elt - ELT;
etmt = elt - ELT0;
printf("%s CPUTime: Total= %g  (Partial= %g) Sec. \n",
       Comm, tcalt, tcal);
printf("ElapsedTime(hh:mm:ss): Total= %02d:%02d:%02d ",
       etmt/3600, (etmt%3600)/60, etmt%60);
printf(" (Partial= %02d:%02d:%02d)\n",
       etm/3600, (etm%3600)/60, etm%60);
 
ELT = elt;
CPUT = cput;
return;
}
