// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive  PIBarGraph
// Drawer Y=f(X)      E.Aubourg, R. Ansari  2004
// (C) LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIBARGRAPH
#define PIBARGRAPH

#include "pisysdep.h"
#include "pidrawer.h"
#include <vector>

// ----------------------------------------------------------
// Classe de representation d'une serie de valeurs sous 
// forme de bar-graph 
 
class PIBarGraph : public PIDrawer {
public:
                     PIBarGraph();
  virtual            ~PIBarGraph();

  int                AddBar(double val, PIColors col);
  int                AddBar(double val);
  
  virtual void       Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);
  virtual void       UpdateLimits();
  
 // Renvoie une distance au point x,y
 // virtual double     GetDistanceToPoint(double x, double y);

protected:
  struct _bgdata { double val; PIColors col; };
  vector<struct _bgdata> mBars;
  double mMin, mMax;
  int aColIdx;
};


#endif
