// Module PI : Peida Interactive  PIBarGraph
// Drawer Y=f(X)      R. Ansari  2004
// (C) LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "machdefs.h"
#include <stdlib.h>
#include <iostream>
#include "pibargraph.h"

// --------------------------------------------------------------------------
// ----------------------------------------------------------
//  Classe de representation d'une serie de valeurs sous 
//  forme de bar-graph  
// ----------------------------------------------------------
// --------------------------------------------------------------------------

//++
// Class	PIBarGraph
// Lib		PI
// include	pibargraph.h
//
//	Classe de representation d'une serie de valeur sous forme de bar-graph
//--
//++
// Links	Parents
// PIDrawer
//--
//++
// Titre	Constructeur
// PIBarGraph::PIBarGraph()
//--


/* --Methode-- */
PIBarGraph::PIBarGraph()
    : PIDrawer()
{
  mMin = 0.; mMax = 1.;
  aColIdx = 0;
} 

/* --Methode-- */
PIBarGraph::~PIBarGraph()
{
}

/* --Methode-- */
int PIBarGraph::AddBar(double val_, PIColors col_)
{
  struct _bgdata bgd;
  bgd.val = val_;
  bgd.col = col_;
  if (mBars.size() == 0) { mMin = mMax = val_; }
  else {
    if (val_ < mMin)  mMin = val_;
    if (val_ > mMax)  mMax = val_;
  }
  mBars.push_back(bgd);
  return mBars.size();
}

/* --Methode-- */
int PIBarGraph::AddBar(double val)
{
#define NACOL_ 8  
  PIColors autocol[NACOL_] = { PI_Red, PI_Blue, 
                  PI_Yellow, PI_Orange, PI_Magenta, 
                  PI_Cyan, PI_NavyBlue, PI_Green };  
  int rc = AddBar(val, autocol[aColIdx]);
  aColIdx = (aColIdx+1)%NACOL_;
  return rc;
}

/* --Methode-- */
void PIBarGraph::UpdateLimits()
{
  if (mBars.size() < 1)  return;
  double xmin, xmax, ymin, ymax;
  xmin = 0.; xmax = mBars.size()+0.5;
  if (mMin*mMax >= 0.) {
    ymin = 0.; ymax = mMax*1.1;
  }
  else {
    ymin = mMin*1.1;  ymax = mMax*1.1;
  }
  PIAxes::ReSizeMinMax(isLogScaleX(),xmin,xmax);
  PIAxes::ReSizeMinMax(isLogScaleY(),ymin,ymax);
  SetLimits(xmin,xmax,ymin,ymax);
  //  SetAxesFlags(kBoxAxes | kExtTicks | kLabels);  Ne pas faire - Reza 05/04->11/99
}


/* --Methode-- */
void PIBarGraph::Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax)
{
  if (mBars.size() < 1) return;
  PIGrCoord x,y,dx,dy;
  for(unsigned int k=0; k<mBars.size(); k++) {
    x = k+0.5; dx = 0.5;
    y = 0.; dy = mBars[k].val;
    g->SelForeground(mBars[k].col);
    g->DrawFBox(x,y,dx,dy);
  }
}


