// Utilisation des flots d'entree-sortie C++
#include <iostream.h>
// Utilisation de la classe Image<T>
#include "outilsinit.h"
#include "cimage.h"
// Utilisation des generateurs aleatoires
#include "nbrandom.h"


// -------- Le programme principal ---------

main(int narg, char *arg[])
{
int i,j;

// ----- ATTENTION -------
// Initialisation de Peida
// A faire au debut de main()
PeidaInit();

cout << " ........ Debut de timg.cc ....... " << endl;
// declaration et creation d'une image de type flottant 300x200
ImageR4  img(300, 200);
ImageR4  imgo(300, 200);
// Remplissage de l'image Tirage aleatoire plat entre 1000-2000
for(i=0; i<300; i++)
  for(j=0; j<200; j++) img(i,j) = imgo(i,j) =  frand01()*1000.+1000.;
// Verification de la dynamique de l'image
img.CheckDyn();
img.Print();
// On sauve l'image ds img.ppf (fichier  format PPersist)
img.Write("img.ppf");


// On rajoute du bruit a l'image (Gaussienne de sigma=3)
for(i=0; i<300; i++)
  for(j=0; j<200; j++) img(i,j) += NorRand()*3. ;

// Verification de la dynamique de l'image
img.CheckDyn();
img.Print();

// On verifie la date de creation du fichier .ppf
  {
  string ppfname = "img.ppf";
  PInPersist pin(ppfname, false);
  cout << "Fichier PPF: " << ppfname << " Version= " << pin.Version() 
       << " Created: " << pin.CreationDate() << endl;
  }
// On cree une nouvelle image 
ImageR4  img2;
// On lit le contenu du fichier imgin.ppf
img2.Read("img.ppf");
// On calcule la difference entre les images img et img2
//    Avant ajout de bruit
cout << "\n imgo(sansbruit) - img2 (fromfile) == 0 ? " << endl;
imgo -= img2;
// Verification de la dynamique de l'image soustraite
imgo.CheckDyn();
imgo.Print();

//    Apres  ajout de bruit
cout << " img(avecbruit) - img2 (fromfile) == Noise, sigma=1 ? " << endl;
img -= img2;
// Verification de la dynamique de l'image soustraite
img.CheckDyn();
img.Print();

cout << " ========= Fin de timg.cc ======== " << endl;
exit(0);
}
