// Module PI : Peida Interactive  PIBarGraph
// Drawer Y=f(X)      R. Ansari  2004
// (C) LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "machdefs.h"
#include <stdlib.h>
#include <iostream>
#include "pibargraph.h"

// --------------------------------------------------------------------------
// ----------------------------------------------------------
//  Classe de representation d'une serie de valeurs sous 
//  forme de bar-graph  
// ----------------------------------------------------------
// --------------------------------------------------------------------------

//++
// Class	PIBarGraph
// Lib		PI
// include	pibargraph.h
//
//	Classe de representation d'une serie de valeur sous forme de bar-graph
//--
//++
// Links	Parents
// PIDrawer
//--
//++
// Titre	Constructeur
// PIBarGraph::PIBarGraph()
//--


/* --Methode-- */
PIBarGraph::PIBarGraph(bool horiz, bool fill)
    : PIDrawer()
{
  idMin = 0.; idMax = 1.;
  mMin = 0.; mMax = 1.;
  //DEL  aColIdx = 0;
  fgFill = fill;
  fgHoriz = horiz;
  fillFrac = 0.5;
} 

/* --Methode-- */
PIBarGraph::~PIBarGraph()
{
}

/* --Methode-- */
int PIBarGraph::AddBar(double id_, double val_, string const& lab_, PIColors col_)
{
  struct _bgdata bgd;
  bgd.id = id_;
  bgd.val = val_;
  bgd.lab = lab_;
  bgd.col = col_;
  if (mBars.size() == 0) { mMin = mMax = val_; idMin = idMax = id_; }
  else {
    if (val_ < mMin)  mMin = val_;
    if (val_ > mMax)  mMax = val_;
    if (id_ < idMin)  idMin = id_;
    if (id_ > idMax)  idMax = id_;
  }
  mBars.push_back(bgd);
  return mBars.size();
}

/* --Methode-- */
int PIBarGraph::AddBar(double val)
{
  string lab = "";
  double id = mBars.size()+0.5;
  return  AddBar(id, val, lab, PI_NotDefColor);
}


static inline void swap_ifhoriz(double& a, double& b) 
{
  double tmp = a;
  a = b;  b = a;
}

/* --Methode-- */
void PIBarGraph::UpdateLimits()
{
  if (mBars.size() < 1)  return;
  double xmin, xmax, ymin, ymax;
  xmin = idMin-fillFrac*(idMax-idMin)/mBars.size(); 
  xmax = idMax+fillFrac*(idMax-idMin)/mBars.size();
  if (mMin*mMax >= 0.) {
    ymin = 0.; ymax = mMax*1.1;
  }
  else {
    ymin = mMin*1.1;  ymax = mMax*1.1;
  }
  if (fgHoriz) {
    swap_ifhoriz(xmin, ymin);
    swap_ifhoriz(xmax, ymax);
  }
  PIAxes::ReSizeMinMax(isLogScaleX(),xmin,xmax);
  PIAxes::ReSizeMinMax(isLogScaleY(),ymin,ymax);
  SetLimits(xmin,xmax,ymin,ymax);
  //  SetAxesFlags(kBoxAxes | kExtTicks | kLabels);  Ne pas faire - Reza 05/04->11/99
}

static inline void swap_ifhoriz_g(PIGrCoord& a, PIGrCoord& b) 
{
  PIGrCoord tmp = a;
  a = b;  b = a;
}

/* --Methode-- */
void PIBarGraph::Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax)
{
  if (mBars.size() < 1) return;
  PIGrCoord x,y,dx,dy;
  double larg = fillFrac*(idMax-idMin)/mBars.size();
  for(unsigned int k=0; k<mBars.size(); k++) {
    x = mBars[k].id-0.5*larg; dx = larg;
    y = 0.; dy = mBars[k].val;
    if (mBars[k].col != PI_NotDefColor) g->SelForeground(mBars[k].col);
    if (fgHoriz) {
      swap_ifhoriz_g(x, y);
      swap_ifhoriz_g(dx, dy);
    }  
    if (fgFill) g->DrawFBox(x,y,dx,dy);
    else { 
      g->DrawBox(x,y,dx,dy);
      if ( mBars[k].lab.length() > 0 ) {
	x = mBars[k].id;
	y = 0.5*mBars[k].val;
	if (fgHoriz) 
	  g->DrawString(y, x, mBars[k].lab.c_str(), 
			PI_VerticalCenter|PI_HorizontalCenter|PI_TextDirectionHorizontal);
	else 
	  g->DrawString(x, y, mBars[k].lab.c_str(), 
			PI_VerticalCenter|PI_HorizontalCenter|PI_TextDirectionVerticalUp);
      }
    }
  }
}


