// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive  PITextDrawer
// Multi Line Text Drawer            R. Ansari  2004
// (C) LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PITEXTDRAWER
#define PITEXTDRAWER

#include "pisysdep.h"
#include "pidrawer.h"
#include <vector>
#include <string>

// ----------------------------------------------------------
// Classe de representation de lignes de texte 
// (+marker et ligne) 
 
class PITextDrawer : public PIDrawer {
public:
                     PITextDrawer(bool fgframe=false);
  virtual            ~PITextDrawer();

  int                AddLine(string const& line, PIGraphicAtt const& att);
  int                AddLine(string const& line);
  inline void        SetFrameFlag(bool fgf) {fgFrame = fgf; }
  
  virtual void       Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);
  virtual void       UpdateLimits();

  virtual int        DecodeOptionString(vector<string> & opt, bool rmdecopt=true);  
  virtual int        OptionToString(vector<string> & opt) const;
  virtual void	     GetOptionsHelpInfo(string& info);
    
protected:
  struct _ldata { string line; PIGraphicAtt att; };
  vector<struct _ldata> mLines;
  bool fgFrame;
};


#endif
