

##############################################################################
##############################################################################
#################### include des librairies pour le link #####################
##############################################################################
##############################################################################

###############################################################################
# Link :                                                                      #
# - without Shared Libraries > make NOSHLIB=y                                 #
# - without Extern Libraries > make NOEXTLIB=y                                #
# - without Fortan Libraries > make NOLFORT=y                                 #
# - with PI Libraries        > make USELIBPI=y                                #
# - with Personal Libraries  > make MYLIBS='-L/home/mylibs -lmylib1 -lmylib2' #
###############################################################################

LIBF =
LIBS =
ELIBF =
ELIBS =
SLIBF =
MLIBS =

#------------------------------------------------------#
#------------------ Archive Libraries -----------------#
#------------------------------------------------------#
ifdef NOSHLIB

#--------- lib sophya ---------
LIBF := $(LIBF) $(LIB)libBaseTools.a $(LIB)libSysTools.a $(LIB)libSUtils.a $(LIB)libNTools.a $(LIB)libTArray.a $(LIB)libHiStats.a 
LIBF := $(LIBF) $(LIB)libSamba.a $(LIB)libSkyMap.a $(LIB)libSkyT.a
LIBS := $(LIBS) -L$(LIB) -lBaseTools -lSysTools -lSUtils -lNTools -lTArray -lHiStats -lSamba -lSkyMap -lSkyT

#--------- lib sophya interface externes ---------
ifndef NOEXTLIB
LIBF := $(LIBF) $(LIB)libFitsIOServer.a $(LIB)libIFFTW.a $(LIB)libLinAlg.a $(LIB)libXAstroPack.a
LIBS := $(LIBS) -lFitsIOServer -lIFFTW -lLinAlg -lXAstroPack
#LIBF := $(LIBF)libBlitz.a
#LIBS := $(LIBS) -lBlitz
endif

#--------- lib piapp ---------
ifdef USELIBPI
LIBF := $(LIBF) $(LIB)libPI.a $(LIB)libPIext.a
LIBS := $(LIBS) -lPI -lPIext
endif

#--------- Other Extern Libraries ---------
ifndef NOEXTLIB
ELIBF := $(ELIBF) $(EXTLIBPATH)libcfitsio.a $(EXTLIBPATH)libfftw.a $(EXTLIBPATH)librfftw.a $(EXTLIBPATH)libxastro.a
ELIBS := $(ELIBS) -L$(EXTLIBPATH) -lcfitsio -lfftw -lrfftw -lxastro
ifeq ($(MACHEROS),OSF1)
ELIBF := $(ELIBF) $(EXTLIBPATH)liblapack.a
ELIBS := $(ELIBS) -llapack -ldxml
endif
ifeq ($(MACHEROS),Linux)
ELIBF := $(ELIBF) $(EXTLIBPATH)liblapack.a $(EXTLIBPATH)libblas.a 
ELIBS := $(ELIBS) -llapack -lblas
endif
ifeq ($(MACHEROS),IRIX64)
ELIBS := $(ELIBS) -lcomplib.sgimath 
endif
endif

#--------- lib system ---------
# librairie des instances de templates cxx Sophya
ifeq ($(CXX),cxx)
SLIBS := $(SLIBS) -lertcxx
endif
SLIBS := $(SLIBS) -lm
# Librairies pour le fortran
ifndef NOLFORT
ifeq ($(MACHEROS),OSF1)
SLIBS := $(SLIBS) -lfor
endif
ifeq ($(MACHEROS),Linux)
#SLIBS := $(SLIBS) -lf2c
SLIBS := $(SLIBS) -lg2c
endif
endif

#-----------------------------------------------------#
#------------------ Shared Libraries -----------------#
#-----------------------------------------------------#
else

#--------- lib sophya ---------
LIBF := $(LIBF) $(SLB)libsophya.so 
LIBS := $(LIBS) -L$(SLB) -lsophya

#--------- lib sophya interface externes ---------
ifndef NOEXTLIB
LIBF := $(LIBF) $(SLB)libextsophya.so 
LIBS := $(LIBS) -lextsophya
endif

#--------- lib piapp ---------
ifdef USELIBPI
LIBF := $(LIBF) $(SLB)libPI.so 
LIBS := $(LIBS) -lPI
endif

#--------- Other Extern Libraries ---------
# ATTENTION actuellement les blabla.a sont appelees,
# on pourrait appeller les blabla.so (EXTSLBPATH) si on les avait crees
ifndef NOEXTLIB
ELIBF := $(ELIBF) $(EXTLIBPATH)libcfitsio.a $(EXTLIBPATH)libfftw.a $(EXTLIBPATH)librfftw.a $(EXTLIBPATH)libxastro.a
ELIBS := $(ELIBS) -L$(EXTLIBPATH) -lcfitsio -lfftw -lrfftw  -lxastro
ifeq ($(MACHEROS),OSF1)
ELIBF := $(ELIBF) $(EXTLIBPATH)liblapack.a
ELIBS := $(ELIBS) -llapack -ldxml
endif
ifeq ($(MACHEROS),Linux)
ELIBF := $(ELIBF) $(EXTLIBPATH)liblapack.a $(EXTLIBPATH)libblas.a 
ELIBS := $(ELIBS) -llapack -lblas
endif
ifeq ($(MACHEROS),IRIX64)
ELIBS := $(ELIBS) -lcomplib.sgimath 
endif
endif

#--------- lib systeme ---------
SLIBS := $(SLIBS) -lm
# Librairies pour le fortran
ifndef NOLFORT
ifeq ($(MACHEROS),OSF1)
SLIBS := $(SLIBS) -lfor
endif
ifeq ($(MACHEROS),Linux)
#SLIBS := $(SLIBS) -lf2c
SLIBS := $(SLIBS) -lg2c
endif
endif

endif

#--------- PERSONAL Libraries ---------
ifdef MYLIBS
  MLIBS := $(MLIBS) $(MYLIBS)
endif

#--------- LIBF et LIBS ---------
LIBF := $(LIBF) $(ELIBF)
LIBS := $(LIBS) $(ELIBS) $(MLIBS) $(SLIBS)

##############################################################################
