#include "machdefs.h"

#include <math.h>
#include <iostream>

#include "tarrinit.h"
#include "array.h"
#include "timing.h"

/*  --------------------------------------------------------- */
/*  ---- Programme de test des operations et conversions ---  */
/*  ----    sur les TArray/TMatrix de SOPHYA    ----          */
/*  2000-2004      -   C. Magneville,  R. Ansari              */
/*  carrt -> Help/Usage                                       */
/*  Pour effectuer les tests :                                */
/* Conversions entre arr<int> et arr<float>                   */
/*  carrt  ac         -> Rc=0 OK                              */
/*  carrt  ace        -> Exception/Rc=9                       */
/*  carrt  oso        -> Rc=0 OK                              */
/*  carrt  odo        -> Rc=0 OK                              */
/*  --- carrt oso/odo NRow NCols  pour test grande tailles    */
/*  --------------------------------------------------------- */

static int test_ac(bool fgszm=false);
static int test_oso(int r, int c);
static int test_odo(int r, int c);

static int prtlev = 0;
static int nprt = 100;

template <class T>
void getMinMax(TArray<T>& a, T& min, T& max) { return a.MinMax(min, max); }

int main(int narg, char* arg[])
{

  SophyaInit();
  InitTim();   // Initializing the CPU timer

  if (narg < 2) {
    cout << " carrt ac/ace/oso/odo [NRow=5] [NCols=10] [prtlev=0] [nprtmax=100] \n"
	 << "   ac : array conversion test   \n" 
	 << "   ace : array conversion test + conversion with sizemismatch -> exception/rc=9  \n" 
	 << "   oso : operation same memory organisation \n" 
	 << "   odo : operation different memory organisation \n" << endl;
    return 1;
  }

  string opt = arg[1];
  int nr = 5;
  int nc = 10;
  if (narg > 2) nr = atoi(arg[2]);
  if (narg > 3) nc = atoi(arg[3]);
  if (narg > 4) prtlev = atoi(arg[4]);
  if (narg > 5) nprt = atoi(arg[5]);

  BaseArray::SetMaxPrint(nprt);
  int rc = 0;
  PrtTim(" Start of Test ");
  try {
    if (opt == "ac") rc = test_ac(false);
    else if (opt == "ace") rc = test_ac(true);
    else if (opt == "oso") rc = test_oso(nr, nc);
    else if (opt == "odo") rc = test_odo(nr, nc);
  }
  catch (PThrowable & exc) {
    cerr << " catched Exception " << exc.Msg() << endl;
    rc = 9;
  }  
  catch (...) {
    cerr << " catched unknown (...) exception " << endl; 
  }  

  PrtTim(" End of Test ");
  cout << " ----- End of carrt - Rc= " << rc << " ----- " << endl;
  if (rc > 255) rc = 255;
  return rc;
}


int test_ac(bool fgszm)
{
  cout << "\n -----> Testing TArray Conversion <---- " << endl;
  int rc = 0;
  int_4 min, max;
  TArray<int_4> ia(7,5),iac,iad;   
  ia = RegularSequence(10., 2.);
  TArray<r_4> ra(7,5);   
  ra = ia;
  if (prtlev>0) 
    cout << " ra = ia(= RegularSequence(10., 2.)) = \n " << ra << endl;
  iac = ra;
  iad = iac-ia;
  getMinMax(iad, min, max);
  if ((min != 0) || (max != 0)) {
    cout << "(1) !!! ERROR ra(7,5)=ia(7,5)  Min=" << min << " Max=" << max << endl;
    rc += 1;
  }
  else cout << "(1) OK  ra(7,5)=ia(7,5)  OK " << endl; 

  TArray<r_4> rb(5,3);
  rb =  RegularSequence(20., .5);  
  TMatrix<int_4> mx(3,5);
  TMatrix<int_4> mxc(3,5);
  mxc = RegularSequence(20., .5);  
  if (prtlev>0) 
    cout << " TArray<r_4> rb(5,3); rb =  RegularSequence(20., .5); rb : " << rb << endl;
  mx = rb;
  if (prtlev>0) 
    cout << " TMatrix<int_4> mx(3,5);       mx = rb;  mx: " << mx << endl;
  TMatrix<int_4> mxd = mxc-mx;
  getMinMax(mxd, min, max);
  if ((min != 0) || (max != 0)) {
    cout << "(2) !!! ERROR mx<int>(5,3)=rb<r_4>(5,3)  Min=" << min << " Max=" << max << endl;
    rc += 2;
  }
  else cout << "(2) OK  mx<int>(5,3)=rb<r_4>(5,3)  OK " << endl; 

  TArray<r_4> rcv(10);
  rcv = 3.1415;
  TMatrix<r_8> mx2(rcv);
  if (prtlev>0) 
    cout << "   TArray<r_4> rcv(10) = 3.1415 , TMatrix<r_8> mx2(rc)=rcv : " << mx2 << endl;
  TMatrix<int_4> mx2d = mx2-3.1415;
  getMinMax(mxd, min, max);
  if ((min != 0) || (max != 0)) {
    cout << "(3) !!! ERROR mx2<r_8>(10)=rcv<r_4>(10)  Min=" << min << " Max=" << max << endl;
    rc += 4;
  }
  else cout << "(3) OK  mx2<r_8>(10)=rcv<r_4>(10)  OK " << endl; 
  if (fgszm) {
    TMatrix<int_4> mx3(3,5);
    cout << "(4) Trying  TMatrix<int_4> mx3(3,5);  mx3 = rcv(10); ?? -> Exception " << endl;
    mx3 = rcv;
  }
  return(rc);
}

int test_oso(int nr, int nc)
{
  cout << "\n -----> Testing TArray operation TArray<int_4>(nx=" << nr << ",ny=" 
       << nc << " ) " << endl;
  cout << " -----> OSO (Same Mem. Mapping) Same memory mapping (default) for all arrays" << endl;

  int rc = 0;
  int min,max;

  TArray<int_4> a(nr,nc);
  a = 20;
  TArray<int_4> b(nr,nc);
  b = 9;
  if (prtlev > 0) {
    cout << " A = \n " << a << endl;
    cout << " B = \n " << b << endl;
  }

  TArray<int_4> ar;
  ar = a+2;  
  if (prtlev > 0) 
    cout << "(1) AR = A+2=  " << ar << endl;
  getMinMax(ar, min, max);
  if ((min != 22) || (max != 22)) {
    cout << "(1) !!! ERROR Test AR=A+2  Min=" << min << " Max=" << max << endl;
    rc += 1;
  }
  else cout << "(1) OK   Test AR=A+2  OK " << endl; 

  ar = 28-a;  
  if (prtlev > 0) 
    cout << "(2) AR = 28-A=  " << ar << endl;
  getMinMax(ar, min, max);
  if ((min != 8) || (max != 8)) {
    cout << "(2) !!! ERROR Test AR=28-A  Min=" << min << " Max=" << max << endl;
    rc += 2;
  }
  else cout << "(2) OK   Test AR=28-A  OK " << endl;
 
  ar = a*3;  
  if (prtlev > 0) 
    cout << "(3) AR = A*3=  " << ar << endl;
  getMinMax(ar, min, max);
  if ((min != 60) || (max != 60)) {
    cout << "(3) !!! ERROR Test AR=A*3  Min=" << min << " Max=" << max << endl;
    rc += 4;
  }
  else cout << "(3) OK   Test AR=A*3  OK " << endl; 

  ar = a/5;  
  if (prtlev > 0) 
    cout << "(4) AR = A/5=  " << ar << endl;
  getMinMax(ar, min, max);
  if ((min != 4) || (max != 4)) {
    cout << "(4) !!! ERROR Test AR=A/5  Min=" << min << " Max=" << max << endl;
    rc += 8;
  }
  else cout << "(4) OK   Test AR=A/5  OK " << endl; 

  ar = 140/a;  
  if (prtlev > 0) 
    cout << "(5) AR = 140/A= \n " << ar << endl;
  getMinMax(ar, min, max);
  if ((min != 7) || (max != 7)) {
    cout << "(5) !!! ERROR Test AR=140/A  Min=" << min << " Max=" << max << endl;
    rc += 16;
  }
  else cout << "(5) OK   Test AR=140/A  OK " << endl; 

  ar -= 3;  
  if (prtlev > 0) 
    cout << "(6) AR -= 3  " << ar << endl;
  getMinMax(ar, min, max);
  if ((min != 4) || (max != 4)) {
    cout << "(6) !!! ERROR Test AR-=3  Min=" << min << " Max=" << max << endl;
    rc += 32;
  }
  else cout << "(6) OK   Test AR-=3  OK " << endl; 


  TArray<int_4> c = a-2*b;
  if (prtlev > 0) 
    cout << "(7) C = A-2*B=  " << c << endl;
  getMinMax(c, min, max);
  if ((min != 2) || (max != 2)) {
    cout << "(7) !!! ERROR Test C=A+2*B  Min=" << min << " Max=" << max << endl;
    rc += 64;
  }
  else cout << "(7) OK   Test C=A+2*B  OK " << endl; 

  (a*4+1).DivElt(b,c);
  if (prtlev > 0) cout << "(8) C = (A*4+1)/B = " << c << endl;
  getMinMax(c, min, max);
  if ((min != 9) || (max != 9)) {
    cout << "(8) !!! ERROR Test C = (A*4+1)/B  Min=" << min << " Max=" << max << endl;
    rc += 128;
  }
  else cout << "(8) OK   Test C = (A*4+1)/B ((DivElt) OK " << endl; 
  
  a = RegularSequence(1, 1);
  b = RegularSequence(nr*nc, -1);
  c = (a*2)+(b*2);
  if (prtlev > 0) {
    cout << "(9) A =  " << a << endl;
    cout << "(9) B =  " << b << endl;
    cout << "(9) C = 2A-2*B=  " << c << endl;
  }
  c /= (nr*nc+1);
  getMinMax(c, min, max);
  if ((min != 2) || (max != 2)) {
    cout << "(9) !!! ERROR Test C=2A+2*B  Min=" << min << " Max=" << max << endl;
    rc += 256;
  }
  else cout << "(9) OK   Test C=2A+2*B  OK " << endl; 
  
  return(rc);
}

int test_odo(int nr, int nc)
{
  cout << "\n -----> Testing TMatrix operation TMatrix<r_4>(nr=" << nr << ",nc=" 
       << nc << " ) " << endl;
  cout << " ----> ODO (Diff. Mem. Mapping) A: CMemoryMapping AR,B,C: FortranMemoryMapping" << endl;

  int rc = 0;
  r_4 min,max;

  TMatrix<r_4> a(nr,nc,BaseArray::CMemoryMapping);
  a = 20;
  TMatrix<r_4> b(nr,nc,BaseArray::FortranMemoryMapping);
  b = 9;

  TMatrix<r_4> ar(nr,nc,BaseArray::FortranMemoryMapping);

  if (prtlev > 0) {
    cout << " A = \n " << a << endl;
    cout << " B = \n " << b << endl;
  }

  a.AddCst(2.,ar);
  if (prtlev > 0) 
    cout << "(1) AR = A+2 : a.AddCst(2,ar) : " << ar << endl;
  getMinMax(ar, min, max);
  if ((fabs(min-22.) > 0.0001) || (fabs(max-22.) > 0.0001)) {
    cout << "(1) !!! ERROR Test AR=A+2  a.AddCst(2,ar)   Min=" << min << " Max=" << max << endl;
    rc += 1;
  }
  else cout << "(1) OK   Test AR=A+2 a.AddCst(2,ar)  OK " << endl; 

  a.SubCst(28.,ar,true);
  if (prtlev > 0) 
    cout << "(2) AR = 28-A : a.SubCst(28,ar,true) :  " << ar << endl;
  getMinMax(ar, min, max);
  if ((fabs(min-8.) > 0.0001) || (fabs(max-8.) > 0.0001)) {
    cout << "(2) !!! ERROR Test AR=28-A  a.SubCst(28,ar,true) Min=" << min << " Max=" << max << endl;
    rc += 2;
  }
  else cout << "(2) OK   Test AR=28-A  a.SubCst(28,ar,true) OK " << endl;
 
  a.MulCst(3.,ar);
  if (prtlev > 0) 
    cout << "(3) AR = A*3= a.MulCst(3,ar)  " << ar << endl;
  getMinMax(ar, min, max);
  if ((fabs(min-60.) > 0.0001) || (fabs(max-60.) > 0.0001)) {
    cout << "(3) !!! ERROR Test AR=A*3  a.MulCst(3,ar) Min=" << min << " Max=" << max << endl;
    rc += 4;
  }
  else cout << "(3) OK   Test AR=A*3  a.MulCst(3,ar) OK " << endl; 

  a.DivCst(5.,ar);
  if (prtlev > 0) 
    cout << "(4) AR = A/5= a.DivCst(5,ar) : " << ar << endl;
  getMinMax(ar, min, max);
  if ((fabs(min-4.) > 0.0001) || (fabs(max-4.) > 0.0001)) {
    cout << "(4) !!! ERROR Test AR=A/5  a.DivCst(5,ar) Min=" << min << " Max=" << max << endl;
    rc += 8;
  }
  else cout << "(4) OK   Test AR=A/5  a.DivCst(5,ar) OK " << endl; 

  a.DivCst(140.,ar,true);
  if (prtlev > 0) 
    cout << "(5) AR = 140/A= a.DivCst(140.,ar,true) : " << ar << endl;
  getMinMax(ar, min, max);
  if ((fabs(min-7.) > 0.0001) || (fabs(max-7.) > 0.0001)) {
    cout << "(5) !!! ERROR Test AR=140/A  a.DivCst(140.,ar,true) Min=" << min << " Max=" << max << endl;
    rc += 16;
  }
  else cout << "(5) OK   Test AR=140/A  a.DivCst(140.,ar,true) OK " << endl; 

  ar -= 3.;  
  if (prtlev > 0) 
    cout << "(6) AR -= 3 " << ar << endl;
  getMinMax(ar, min, max);
  if ((min != 4) || (max != 4)) {
    cout << "(6) !!! ERROR Test AR-=3  Min=" << min << " Max=" << max << endl;
    rc += 32;
  }
  else cout << "(6) OK   Test AR-=3  OK " << endl; 

  TMatrix<r_4> c(nr,nc,BaseArray::FortranMemoryMapping);
  c = a-(b*2.0f);
  if (prtlev > 0) cout << "(7) C = A-2*B=  " << c << endl;

  getMinMax(c, min, max);
  if ((fabs(min-2.) > 0.0001) || (fabs(max-2.) > 0.0001)) {
    cout << "(7) !!! ERROR Test C=A+2*B  Min=" << min << " Max=" << max << endl;
    rc += 64;
  }
  else cout << "(7) OK   Test C=A+2*B  OK " << endl; 

  (a*4.0f+5.5f).DivElt(b,c);
  if (prtlev > 0) cout << "(8) C = (A*4+12)/B = " << c << endl;
  getMinMax(c, min, max);
  if ((fabs(min-9.5) > 0.0001) || (fabs(max-9.5) > 0.0001)) {
    cout << "(8) !!! ERROR Test C = (A*4+12)/B  Min=" << min << " Max=" << max << endl;
    rc += 128;
  }
  else cout << "(8) OK   Test C = (A*4+12)/B  OK " << endl; 

  a = RegularSequence(1, 1);
  b = RegularSequence(nr*nc, -1);
  c = (a*2.f)+(b*2.f);
  if (prtlev > 0) {
    cout << "(9) A =  " << a << endl;
    cout << "(9) B =  " << b << endl;
    cout << "(9) C = 2A-2*B= " << c << endl;
  }
  c /= (nr*nc+1);
  getMinMax(c, min, max);
  if ((fabs(min-2.) > 0.0001) || (fabs(max-2.) > 0.0001)) {
    cout << "(9) !!! ERROR Test3 C=2A+2*B  Min=" << min << " Max=" << max << endl;
    rc += 256;
  }
  else cout << "(9) OK   Test3 C=2A+2*B  OK " << endl; 

  return(rc);

}
