// Test des possibilites de xastropack
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <string.h>
#include <math.h>
#include "xastropack.h"

/*==========================================================================*/
#if 1
// Test de InRange InRangeCoLat InRangeLat
int main(int narg, char *arg[])
{
  if(narg<3) {
    cout<<"usage: tstxastro range,vmax val,u"<<endl
        <<"          u = unite de val (h,d,r def=r)"<<endl;
    return -1;
  }

  double range,vmax=-12345.6789;
  sscanf(arg[1],"%lf,%lf",&range,&vmax);
  if(vmax==-12345.6789) vmax = range/2.;
  double val0,val; char unite='r';
  sscanf(arg[2],"%lf,%c",&val0,&unite);

  val = val0; InRange(val,range);
  printf("InRange(%.9f, %.2f) = %.9f\n",val0,range,val);
  val = val0; InRange(val,range,vmax);
  printf("InRange(%.9f, %.2f, %.2f) = %.9f\n",val0,range,vmax,val);

  unsigned long un;
  if(unite=='h') un = TypUniteH;
    else if(unite=='d') un = TypUniteD;
      else un = TypUniteR;
  val = val0; InRangeCoLat(val,un);
  printf("InRangeCoLat(%.9f %c) = %.9f\n",val0,unite,val);
  val = val0; InRangeLat(val,un);
  printf("InRangeLat(%.9f %c) = %.9f\n",val0,unite,val);
  
  return 0;
}
#endif

/*==========================================================================*/
#if 0
// Test de DecodeTypAstro
int main(int narg, char *arg[])
{
  if(narg<2) {
    cout<<"usage: tstxastro ctype"<<endl;
    return -1;
  }

  cout<<"ctype = "<<arg[1]<<endl;
  unsigned long typ = DecodeTypAstro(arg[1]);
  string s = DecodeTypAstro(typ);
  cout<<"typ = "<<typ<<" from "<<s<<endl;

  cout<<"...TypCoordEq  "<<(typ&TypCoordEq)<<endl;
  cout<<"...TypCoordGal "<<(typ&TypCoordGal)<<endl;
  cout<<"...TypCoordHor "<<(typ&TypCoordHor)<<endl;
  cout<<"...TypCoordEcl "<<(typ&TypCoordEcl)<<endl;

  cout<<"...TypCoord1H "<<(typ&TypCoord1H)<<endl;
  cout<<"...TypCoord1D "<<(typ&TypCoord1D)<<endl;
  cout<<"...TypCoord1R "<<(typ&TypCoord1R)<<endl;

  cout<<"...TypCoord1C "<<(typ&TypCoord1C)<<endl;
  cout<<"...TypCoord1L "<<(typ&TypCoord1L)<<endl;

  cout<<"...TypCoord2H "<<(typ&TypCoord2H)<<endl;
  cout<<"...TypCoord2D "<<(typ&TypCoord2D)<<endl;
  cout<<"...TypCoord2R "<<(typ&TypCoord2R)<<endl;

  cout<<"...TypCoord2C "<<(typ&TypCoord2C)<<endl;
  cout<<"...TypCoord2L "<<(typ&TypCoord2L)<<endl;

  unsigned long typu1 = GetCoordUnit(1,typ);
  cout<<"\ntypu1 = "<<typu1<<endl;
  cout<<"...TypCoordH "<<(typu1&TypUniteH)<<endl;
  cout<<"...TypCoordD "<<(typu1&TypUniteD)<<endl;
  cout<<"...TypCoordR "<<(typu1&TypUniteR)<<endl;

  unsigned long typu2 = GetCoordUnit(2,typ);
  cout<<"\ntypu2 = "<<typu2<<endl;
  cout<<"...TypCoordH "<<(typu2&TypUniteH)<<endl;
  cout<<"...TypCoordD "<<(typu2&TypUniteD)<<endl;
  cout<<"...TypCoordR "<<(typu2&TypUniteR)<<endl;
  
  return 0;
}
#endif

/*==========================================================================*/
#if 0
// Test de CoordConvertToStd
int main(int narg, char *arg[])
{
  if(narg<2) {cout<<"usage: tstxastro ctype A,B"<<endl;return -1;}
  double coord1_ini=0., coord2_ini=0.;
  if(narg>2) sscanf(arg[2],"%lf,%lf",&coord1_ini,&coord2_ini);

  printf("ctype = %s\n",arg[1]);
  unsigned long typ = DecodeTypAstro(arg[1]);
  string str = DecodeTypAstro(typ);

  double coord1 = coord1_ini, coord2 = coord2_ini;
  unsigned long newtyp = CoordConvertToStd(typ,coord1,coord2);
  string newstr = DecodeTypAstro(newtyp);

  printf("typ = %lo %s ==> newtyp = %lo %s\n"
        ,typ,str.c_str(),newtyp,newstr.c_str());
  printf("coord1 %.6f  ==>  %.6f\n",coord1_ini,coord1);
  printf("coord2 %.6f  ==>  %.6f\n",coord2_ini,coord2);
  return 0;
}
#endif
