// Classe d'initialisation du module HiStats 
//                        (Histogram and Statistics)

#include "machdefs.h"
#include "histinit.h"

#include "histos.h"
#include "histos2.h"
#include "hisprof.h"
#include "histerr.h"
#include "ntuple.h"
#include "xntuple.h"

/*!
   \defgroup HiStats HiStats module
   This module contains histograms
*/
 
int HiStatsInitiator::FgInit = 0;

/*!
  \class SOPHYA::HiStatsInitiator
  \ingroup HiStats
  Histograms initiator
*/
HiStatsInitiator::HiStatsInitiator()
  : NToolsInitiator()
{
  FgInit++;
  if (FgInit > 1)  return;

//   Enregistrement des classes PPersist du modules HiStats
  
  PPRegister(ObjFileIO<Histo>);
  DObjRegister(ObjFileIO<Histo>, Histo);
  PPRegister(ObjFileIO<Histo2D>);
  DObjRegister(ObjFileIO<Histo2D>, Histo2D);
  PPRegister(ObjFileIO<HProf>);
  DObjRegister(ObjFileIO<HProf>, HProf);
  PPRegister(ObjFileIO<HistoErr>);
  DObjRegister(ObjFileIO<HistoErr>, HistoErr);

  PPRegister(ObjFileIO<NTuple>);
  DObjRegister(ObjFileIO<NTuple>, NTuple);
  PPRegister(ObjFileIO<XNTuple>);
  DObjRegister(ObjFileIO<XNTuple>, XNTuple);

}

HiStatsInitiator::~HiStatsInitiator()
{
  FgInit--;
}


// On met un objet initiator en statique, pour les loaders qui savent 
// appeler le constructeur des objets statiques   Reza 08/98
static HiStatsInitiator histatsinit;

