#include "sopnamsp.h"
#include "machdefs.h"
#include "tabmath.h"

///////////////////////////////
//  Exponentielles tabulees  //
///////////////////////////////

TabFExp::TabFExp()
{
  tab = new double[10000];

  for(int i=0; i<10000; i++)
    tab[i] = exp(-(double)i*0.001) ;
}

TabFExp::~TabFExp()
{
  delete[] tab;
}

TabFExp* SOPHYA::ptabFExp;

////////////////////////////////////
//    Sinus tabules (et Cosinus)  //
////////////////////////////////////

TabFSin::TabFSin(int n)
{
  if(n<=1) n=10000;
  tab = new double[n];
  delta = Pi/2. / (double) (n-1);
  for(int i=0; i<n; i++)
    tab[i] = sin((double)i* delta) ;
}

TabFSin::~TabFSin()
{
  delete[] tab;
}

TabFSin* SOPHYA::ptabFSin;
