#include "sopnamsp.h"
#include "machdefs.h"
#include <stdlib.h>
#include <typeinfo>
#include <iostream>
#include <string>

#include "nomspecrespadapter.h"
#include "specrespvector.h"
#include "gaussfilt.h"
#include "pidrawer.h"

// ------ Classe de Drawer pour tracer Y = Transmission(nu = X) 
class PISpectralResponseDrawer : public PIDrawer {
public :
 	       PISpectralResponseDrawer(SpectralResponse* sr, bool ad=false);
 	       ~PISpectralResponseDrawer();
  virtual void Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax);
  virtual void UpdateLimits();

protected:
SpectralResponse * mSR;
bool mAd;
};

PISpectralResponseDrawer::PISpectralResponseDrawer(SpectralResponse* sr, bool ad)
{
mSR = sr;
mAd = ad;
}

PISpectralResponseDrawer::~PISpectralResponseDrawer()
{
if (mAd && mSR)  delete mSR;
}

void
PISpectralResponseDrawer::Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax)
{
  if (!mSR) return;
  PIGrCoord x1, x2, y1, y2;
  g->GetGrSpace(x1, x2, y1, y2);
  double xMax = x2;
  double xMin = x1;
  double yMax = y2;
  double yMin = y1;
  double xStep = (xMax - xMin)/100;
  double xOld = xMin;
  double yOld = mSR->transmission(xMin);
  double x,y;
  for (x = xMin+xStep; x<xMax; x+=xStep) {
    y = mSR->transmission(x);
    if (y>yMin && yOld>yMin && 
        y<yMax && yOld<yMax) 
           g->DrawLine(xOld, yOld, x, y);
    xOld = x;
    yOld = y;
  }
}

void
PISpectralResponseDrawer::UpdateLimits()
{
  if (!mSR) return;
  double xmin, xmax;
  double ymin, ymax;
  xmin = mSR->minFreq();
  xmax = mSR->maxFreq();
  double dx = (xmax-xmin)*0.025;
  xmin -= dx;  xmax += dx;
  ymin = 0.;
  ymax = mSR->peakTransmission()*1.05;
  SetLimits(xmin, xmax, ymin, ymax);
//  cout << " DBG - " << xmin << "," << xmax << "   " << ymin << "," << ymax << endl;
}
//-------------------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet SpectralResponse
//-------------------------------------------------------------------------

/* --Methode-- */
NOMAdapter_SpectralResponse::NOMAdapter_SpectralResponse(SpectralResponse* o)
  : NObjMgrAdapter(o)
{
mSR = o;
}

/* --Methode-- */
NOMAdapter_SpectralResponse::~NOMAdapter_SpectralResponse()
{
}

/* --Methode-- */
NObjMgrAdapter* NOMAdapter_SpectralResponse::Clone(AnyDataObj* o)
{
SpectralResponse* sr = dynamic_cast<SpectralResponse *>(o);
if (sr) return ( new NOMAdapter_SpectralResponse(sr) );
return ( new NObjMgrAdapter(o) );
}


/* --Methode-- */
void NOMAdapter_SpectralResponse::SavePPF(POutPersist& pos, string const & nom)
{
  GaussianFilter* gf = dynamic_cast<GaussianFilter *> (mSR);
  SpecRespVec*    vecFilt   = dynamic_cast<SpecRespVec    *> (mSR);
  if (gf) { // C'est un GaussianFilter ....
    ObjFileIO<GaussianFilter> oio(gf);
    oio.Write(pos, nom);
  }
  else if (vecFilt) {
    ObjFileIO<SpecRespVec> oio(vecFilt);
    oio.Write(pos, nom);
  }
  else {
   string s = typeid(*mSR).name();
   cout << "NOMAdapter_SpectralResponse::SavePPF() - Error : Not supported for " << s << endl;
  }
}

/* --Methode-- */
void NOMAdapter_SpectralResponse::Print(ostream& os)
{
os << (*mSR);
}

/* --Methode-- */
PIDrawer* NOMAdapter_SpectralResponse::GetDrawer(string & dopt)
{
return(new PISpectralResponseDrawer(mSR, false));
}


/* --Methode-- 
NTupleInterface* NOMAdapter_SpectralResponse::GetNTupleInterface(bool& adel)
{ 
adel = true;
return( new NTupInt_SpectralResponse(mSR) );
}
*/


