/* Interface Fits BINARY/ASCII Table     cmv 21/05/2001 */
#include "sopnamsp.h"
#include "machdefs.h"
#include <stdlib.h>
#include <stdio.h>
#include <typeinfo>
#include <iostream>
#include <string.h>
#include <string>

#include "nobjmgr.h"
#include "servnobjm.h"
#include "nomgadapter.h"
#include "pistdimgapp.h"
#include "fbtntintf.h"

////////////////////////////////////////////////////////////
class NOMAdapter_FitsBT : public NObjMgrAdapter {
public:
  NOMAdapter_FitsBT(FitsBTNtuIntf* o = NULL);
  virtual ~NOMAdapter_FitsBT();

  virtual NObjMgrAdapter* Clone(AnyDataObj* o);
  virtual string GetDataObjType();
  virtual AnyDataObj* CloneDataObj(bool share=false);
  virtual void SavePPF(POutPersist& s, string const & nom);
  virtual void Print(ostream& os);
  virtual NTupleInterface* GetNTupleInterface(bool& adel);

protected:
  FitsBTNtuIntf* mFBT;
};

////////////////////////////////////////////////////////////
NOMAdapter_FitsBT::NOMAdapter_FitsBT(FitsBTNtuIntf* o)
 : NObjMgrAdapter(o)
{
mFBT = o;
}

NOMAdapter_FitsBT::~NOMAdapter_FitsBT()
{
}

NObjMgrAdapter* NOMAdapter_FitsBT::Clone(AnyDataObj* o)
{
FitsBTNtuIntf* g = dynamic_cast<FitsBTNtuIntf *>(o);
if(g) return ( new NOMAdapter_FitsBT(g) );
return ( new NObjMgrAdapter(o) );
}

string NOMAdapter_FitsBT::GetDataObjType()
{
return( "FitsBTNtuIntf " );
}

AnyDataObj* NOMAdapter_FitsBT::CloneDataObj(bool /*share*/)
{
return( new FitsBTNtuIntf(*mFBT) );
}

void NOMAdapter_FitsBT::SavePPF(POutPersist& pos, string const & nom)
{
cout<<"NOMAdapter_FitsBT::SavePPF: not implemented"<<endl;
}

void NOMAdapter_FitsBT::Print(ostream& os)
{
mFBT->Print(os,99);
}

NTupleInterface* NOMAdapter_FitsBT::GetNTupleInterface(bool& adel)
{
adel = false;
return(mFBT);
}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
extern "C" {
void fitsbtadapter_init();
void fitsbtadapter_end();
}

class fitsbtadapterExecutor : public CmdExecutor {
public:
  fitsbtadapterExecutor();
  virtual ~fitsbtadapterExecutor();
  virtual int Execute(string& keyw, vector<string>& args, string& toks);
};

///////////////////////////////////////////////////////////
fitsbtadapterExecutor::fitsbtadapterExecutor()
{
NamedObjMgr omg;
PIACmd * mpiac = omg.GetImgApp()->CmdInterpreter();

// On enregistre l'adaptateur
Services2NObjMgr* serv = omg.GetServiceObj();
serv->RegisterClass(new FitsBTNtuIntf, new NOMAdapter_FitsBT);

// On enregistre la commande 
string hgrp = "FileIO";
string kw = "fitsadapt";
string usage = "fitsadapt: NTuple adaptor for Binary and ASCII Fits table\n" ;
usage += "Usage: fitsadapt fitsfile [nomobj hdu buflen[,bufsens,lp]]";
usage += "\n fitsfile : Fits file name";
usage += "\n nomobj : Object name (needed if file name misleading as C++ variable)";
usage += "\n hdu : Fits HDU (if <=0 take first binary/ascii table)";
usage += "\n buflen[,bufsens,lp] : buffer length (sens) for fits reading (default is 100,1,0)";
mpiac->RegisterCommand(kw, usage, this, hgrp);
}

fitsbtadapterExecutor::~fitsbtadapterExecutor()
{
}

int fitsbtadapterExecutor::Execute(string& kw, vector<string>& tokens, string&)
{
NamedObjMgr omg;
if(kw == "fitsadapt") {
  if(tokens.size()<1)
    {cout<<"Usage: fitsadapt fitsfile [nomobj hdu buflen[,bufsens]]"<<endl;
     return(0);}
    int ihdu=0;
    int_4 buflen=100, bufsens=1, lp=0;
    string fname = tokens[0];
    string nom_obj ="";
    if(tokens.size()>1) nom_obj = tokens[1];
    if(tokens.size()>2) sscanf(tokens[2].c_str(),"%d",&ihdu);
    if(tokens.size()>3) sscanf(tokens[3].c_str(),"%d,%d,%d",&buflen,&bufsens,&lp);
    FitsBTNtuIntf* fbt = new FitsBTNtuIntf(fname,ihdu,buflen,bufsens,lp);

    if(nom_obj=="" || nom_obj=="!") nom_obj = omg.GetServiceObj()->FileName2Name(fname);
    omg.AddObj(fbt,nom_obj);
 }
 return(0);
}

///////////////////////////////////////////////////////////
static fitsbtadapterExecutor * piafbtex = NULL;

void fitsbtadapter_init()
{
if(piafbtex) delete piafbtex;
piafbtex = new fitsbtadapterExecutor;
}

void fitsbtadapter_end()
{
if(piafbtex) delete piafbtex;
piafbtex = NULL;
}
