#include <iostream>
#include "sopnamsp.h"
#include "datacirclefake.h"

DataCircleFake::DataCircleFake() : _NMeasurements(0), _mesures(NULL) 
{;}

DataCircleFake::DataCircleFake(double theta,double phi,double aperture,int NEch,double tl) : DataCircleBase(theta,phi,aperture), _NMeasurements(NEch), _mesures(NULL)
{
  _mesures= new double[NEch];
  int i;
  for(i = 0; i < NEch; i++) {
    _mesures[i]= tl;
  }
}

DataCircleFake::~DataCircleFake()
{
  if(_mesures != NULL) delete [] _mesures;
}

double DataCircleFake::getData(double psi) const {

  int ibin= l_ft_nint(psi*_NMeasurements/(2.*M_PI));
  //cout << "bin= " << ibin << ", " << _mesures[ibin] << endl;
  return _mesures[ibin];
}

int DataCircleFake::NMeasurements() const { 

  return _NMeasurements;
}

void DataCircleFake::print(ostream& out) const {

  out << " Circle:: ApertureAngle= " << ApertureAngle() << ", Theta= " 
      << Theta() << ", Phi= " << Phi() << ", NSamples= " 
      << NMeasurements() << endl;
}

double DataCircleFake::getTMeasure(double psi) const {

  if(_mesures == NULL) {
    cout << "  DataCircleFake::getTMeasure data must be stored"
	 << " in an array... " << endl;
    exit(0);
  }
  int ibin= l_ft_nint(psi*_NMeasurements/(2.*M_PI));
  return _mesures[ibin];
}
