#ifndef HISTERR_SEEN
#define HISTERR_SEEN

#include "objfio.h"
#include <iostream>
#include <stdio.h>
#include "histos.h"

namespace SOPHYA {

//! 1 dimension histograms with errors given by user
class HistoErr : public Histo {
  friend class ObjFileIO<HistoErr>;
public:

  // CREATOR / DESTRUCTOR
  HistoErr(void);
  HistoErr(r_8 xMin, r_8 xMax, int_4 nBin=100);
  HistoErr(const HistoErr& H);
  virtual ~HistoErr(void);

  // UPDATING or SETTING
  void Zero(void);
  //! Addition du contenu de l'histo pour abscisse x poids w et l'erreur e
  void Add(r_8 x, r_8 w=1., r_8 e=1.);
  //! Addition du contenu de l'histo pour le bin numBin poids w et l'erreur e
  void AddBin(int_4 numBin, r_8 w=1., r_8 e=1.);
  //! remplissage contenu de l'histo pour le bin numBin poids w et l'erreur e
  void SetBin(int_4 numBin, r_8 w=1., r_8 e=1., uint_4 nb=1);
  //! remplissage nombre d'entrees pour le bin numBin
  void SetNentB(int_4 numBin, uint_4 nb=1);

  //! Retourne le nombre d'entree dans le bin
  inline uint_4 NEntBin(int_4 i) const
         {if(mNData) return mNData[i]; else return 0;}

  //! get/put from/to a vector
  void GetNBin(TVector<int_4>& v) const;
  void PutNBin(TVector<int_4>& v);

  //! Re-center bin abscissa
  void ReCenterBin(r_8 xcmin,r_8 xcmax);
  //! Compute the correlation histogram
  void ToCorrel(void);

  // Operators
  HistoErr& operator = (const HistoErr& h);

protected:
  void allocate_mNData(int nbin);
  void Delete(void);

  uint_4* mNData;    //!< nombre d'entrees dans chaque bin
};

/*! \ingroup HiStats \fn operator<<(POuttPersist&,HistoErr)
  \brief Persistance management */
inline POutPersist& operator << (POutPersist& os, HistoErr & obj)
{ ObjFileIO<HistoErr> fio(&obj);  fio.Write(os);  return(os); }
/*! \ingroup HiStats \fn operator<<(POuttPersist&,HistoErr)
  \brief Persistance management */
inline PInPersist& operator >> (PInPersist& is, HistoErr & obj)
{ ObjFileIO<HistoErr> fio(&obj); is.SkipToNextObject(); fio.Read(is); return(is); }

} // Fin du namespace

#endif // HISTERR_SEEN
