#ifndef LONGLAT_H_SEEN
#define LONGLAT_H_SEEN

#include <math.h>
#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include "utilgeom.h"

/*
  passage des coordonnees longitude, latitude en theta,phi
  longitude=phi
  latitude=Pi/2-theta
*/

class LongLat
{
  
 public:
  
  LongLat();
  LongLat(double longitude, double latitude);
  LongLat(double x, double y, double z);
  LongLat(const LongLat&);
  
  void Set(double longitude, double latitude);
  double Longitude() const {return _lon;}
  double Phi() const {return _lon;}
  double Latitude() const {return _lat;}
  double Theta() const {return pi_over_2-_lat;}

  void Print(ostream& os) const;
  
 private:
  
  double _lon; // lambda
  double _lat; // beta
  
};

inline ostream& operator<<(ostream& s, const LongLat& ll) 
{  
  ll.Print(s);  
  return s;  
}

#endif
