#ifndef VECTOR3D_H_SEEN
#define VECTOR3D_H_SEEN

#include <math.h>
#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include "longlat.h"

/*
  Geometrie en dimension 3. 
  Tous les calculs sont faits en radians 
  et en coordonnees spheriques theta,phi
  pour les rotations (angles d'Euler) ma source est 
  "Classical Mechanics" 2nd edition, H. Goldstein, Addison Wesley
*/

class Vector3d 
{

 public:
  
  Vector3d();
  Vector3d(double x, double y, double z);
  Vector3d(double theta, double phi);
  Vector3d(const LongLat&);
  Vector3d(const Vector3d&);

  void Setxyz(double x, double y, double z);
  void SetThetaPhi(double theta,  double phi);
  void ThetaPhi2xyz();
  void xyz2ThetaPhi();
  double Theta() const {return _theta;}
  double Phi() const {return _phi;}
  double X() const {return _x;}
  double Y() const {return _y;}
  double Z() const {return _z;}

  Vector3d& Normalize();
  double Norm() const;

  // produit scalaire
  double Psc(const Vector3d&) const;

  // ecart angulaire entre 2 vecteurs dans [0,Pi]
  double SepAngle(const Vector3d&) const;

  // produit vectoriel
  Vector3d Vect(const Vector3d&) const;

  // vecteur perpendiculaire de meme phi
  Vector3d VperpPhi() const;

  // vecteur perpendiculaire de meme theta
  Vector3d VperpTheta() const;

  Vector3d ETheta() const;
  Vector3d EPhi() const;

  // rotations d'Euler
  Vector3d Euler(double, double, double) const;

  // rotation inverse
  Vector3d InvEuler(double, double, double) const;

  // rotation d'angle phi autour d'un axe omega (regle du tire-bouchon)
  Vector3d Rotate(const Vector3d& omega,double phi);

  virtual Vector3d& operator=(const Vector3d&);
  virtual Vector3d& operator+=(const Vector3d&);
  virtual Vector3d& operator-=(const Vector3d&);
  virtual Vector3d operator+(const Vector3d&) const;
  virtual Vector3d operator-(const Vector3d&) const;

  Vector3d& operator+=(double);
  Vector3d& operator/=(double);
  Vector3d& operator*=(double);

  Vector3d operator+(double) const;
  Vector3d operator-(double) const;
  Vector3d operator*(double) const;
  Vector3d operator/(double) const;
  Vector3d operator^(const Vector3d&) const; // produit vectoriel
  double operator*(const Vector3d&) const; // produit scalaire
  bool operator==(const Vector3d&);
  
  virtual void Print(ostream& os) const;

 protected:

  double _x;
  double _y;
  double _z;
  double _theta;
  double _phi;

};

inline ostream& operator<<(ostream& s, const Vector3d& v) 
{  
  v.Print(s);  
  return s;  
}

// fonctions globales

inline Vector3d operator*(double d, const Vector3d& v) 
{
  return v*d;
}

inline Vector3d operator+(double d, const Vector3d& v) 
{
  return v+d;
}

#endif


