#include "sopnamsp.h"
#include "machdefs.h"
#include <stdio.h>
#include <stdlib.h>
#include "math.h"
#include <iostream>
#include <string>

#include <typeinfo>
#include "timing.h"
#include "histinit.h"
#include "pexceptions.h"
#include "segdatablock.h"
#include "fiosegdb.h" 
#include "swsegdb.h" 
#include "ppfswapper.h" 
#include "ppfwrapstlv.h"

/*  Programme test des classes  SegDataBlock<T> et son PPF writer */
/*  SwSegDataBlock<T> avec le swapper PPF                         */
/*  SOPHYA - R. Ansari (LAL)  -   Avril 2005                      */
 
int main(int narg, char* arg[])
{
  cout << " ---- Programme tstsegdb.cc ----- \n" 
       << "     Test classe SegDataBlock<T> et  SwSegDataBlock<T>  " << endl;
  int rc = 0;
  try {
      SophyaInit();

    InitTim(); 
    cout << "1/ Test SegDataBlock Creation,remplissage, impression (segi, ssegi, sgds" << endl;
    SegDataBlock<int> segi;
    segi.Extend();
    cout << segi;

    SegDataBlock<int> ssegi(segi);
    segi = 432;
    ssegi.Extend(); 
    ssegi.Print(cout, 4, " , ");
    SegDataBlock<string> sgds(5,3); 
    cout << sgds;
    sgds[2] = "bonjour";  sgds[5] = "AAAA"; 
    sgds[8] = "BbbBBbb";
    sgds.Print(cout, 4, " ; ");
 
    {
      cout << "2/ Ecriture segi sgds et ssegi dans segdb.ppf " << endl;
      POutPersist so("segdb.ppf");
      so << segi << sgds << ssegi;
    }
    {
      cout << "3/ Lecture depuis segdb.ppf et print " << endl;
      SegDataBlock<int> rsd1, rsd2;
      SegDataBlock<string> rsds;
      PInPersist si("segdb.ppf");
      si >> rsd1 >> rsds >> rsd2;
      rsds.Print(cout, 4, " ; ");
      cout << "4/ On modifie certains elements de rsd1 et on verifie le partage de reference en lecture" << endl;
      for(int jj=0; jj<rsd1.Size(); jj += 9) 
	rsd1[jj] = 999;
      rsd1.Print(cout, 4, " , ");
      rsd2.Print(cout, 4, " , ");
    }
    cout << "5/ Test  SwSegDataBlock<T>  creation/remplissage  " << endl;
    int SWSEGSZ = 4;
    {
      cout << " Creation PPFDataSwapper<float> swout(so) avec swseg.ppf " << endl;
      POutPersist so("swseg.ppf");
      PPFDataSwapper<float> swout(so);
      SwSegDataBlock<float> swsd(swout, SWSEGSZ, 3);
      float * fp = swsd.GetSegment(0);
      fp[0] = 6.54321;   fp[1] = 65.4321;  fp[2] = 654.321;  fp[3] = 6543.21;
      fp = swsd.GetSegment(1);
      fp[0] = 2.56789;   fp[1] = 25.6789;  fp[2] = 256.789;  fp[3] = 2567.89;
      fp = swsd.GetSegment(2);
      fp[0] = 12.567;   fp[1] = 225.67;  fp[2] = 3256.7;  fp[3] = 42567.;
      vector<int_8> tags = swsd.GetSwapPosTagTable();
      so << tags;
    }
    {
      cout << "6/ Creation PPFDataSwapper<float> avec lecture depuis swseg.ppf " << endl;
      PInPersist si("swseg.ppf");
      PPFDataSwapper<float> swin(si);
      vector<int_8> tags;
      si >> tags;
      SwSegDataBlock<float> swsd(swin, tags, SWSEGSZ);
      cout <<"7/ Recopie ds SegDataBlock<float> depuis SwSegDataBlock<float> et print" << endl;
      SegDataBlock<float> segf,segf2;
      segf = swsd;
      segf.Print(cout, 4, "  ");
      segf2 = swsd;
      segf2.Print(cout, 4, "  ");
    }
   
  }
  catch (PThrowable & exc) {
    cerr << " tstsegdb.cc: Catched Exception (PThrowable)" << (string)typeid(exc).name() 
	 << " - Msg= " << exc.Msg() << endl;
    rc = 99;
  }
  catch (std::exception & e) {
    cerr << " tstsegdb.cc: Catched std::xception "  
	 << " - what()= " << e.what() << endl;
    rc = 98;
  }
  catch (...) {
    cerr << " tstsegdb.cc: some other exception (...) was caught ! " << endl;
    rc = 97;
  }
  PrtTim("End tstsegdb " );
  cout << " ---- Programme tstsegdb.cc -  FIN  (Rc=" << rc << ") --- " << endl;
  return rc;
}
