#ifndef MACHDEFS_SEEN
#define MACHDEFS_SEEN

/***********************************************************************/
/* Find hardware, OS and compiler combination                          */
/***********************************************************************/

#if defined(__alpha) || defined(__alpha__) || defined(OSF1) || defined(DECALPHA)
#define MACH_ALPHA
#define OS_OSF1
#endif

#if defined(_AIX) && !defined(AIX)
#define MACH_IBMRS
#define OS_AIX
#endif

#if defined(__hpux__) && !defined(HPUX)
#define MACH_HP
#define OS_HPUX
#endif

#ifdef __MWERKS__
#define MACH_POWERMAC
#define OS_MACOS
#endif

#ifdef sun
#define MACH_SUN
#define OS_SOLARIS
#endif

#ifdef IRIX64
#define MACH_SGI
#define OS_IRIX64
#endif

#if defined(Linux)  || defined(linux)
#define MACH_INTEL
#define OS_LINUX
#endif


/***********************************************************************/
/* Hardware/OS dependent stuff                                         */
/***********************************************************************/

#if defined(OS_OSF1)

  typedef signed char int_1;
  typedef unsigned char uint_1;
  typedef int int_4;
  typedef unsigned int uint_4;
  typedef short int_2;
  typedef unsigned short uint_2;
  typedef float r_4;
  typedef double r_8;
  typedef long long int_8;
  typedef unsigned long long uint_8;

#define  SWAP 1
#define  SWAPDEFAUT 1

#elif  defined(OS_HPUX)

  typedef signed char int_1;
  typedef unsigned char uint_1;
  typedef int int_4 ;
  typedef unsigned int uint_4;
  typedef short int_2;
  typedef unsigned short uint_2;
  typedef float r_4;
  typedef double r_8;
  typedef long long int_8;
  typedef unsigned long long uint_8;

#define  SWAP 0
#define  SWAPDEFAUT   0


#elif  defined( OS_AIX )

  typedef signed char int_1;
  typedef unsigned char uint_1;
  typedef int int_4;
  typedef unsigned int uint_4;
  typedef short int_2;
  typedef unsigned short uint_2;
  typedef float r_4;
  typedef double r_8;
  typedef long long int_8;
  typedef unsigned long long uint_8;

#define  SWAP 0
#define  SWAPDEFAUT   0

/* Check for solaris on intel... */
#elif  defined( OS_SOLARIS ) && defined( MACH_SUN )

  typedef signed char int_1;
  typedef unsigned char uint_1;
  typedef int int_4;
  typedef unsigned int uint_4;
  typedef short int_2;
  typedef unsigned short uint_2;
  typedef float r_4;
  typedef double r_8;
  typedef long long int_8;
  typedef unsigned long long uint_8;

#define  SWAP 0
#define  SWAPDEFAUT   0

#elif  defined( OS_IRIX64 )

  typedef signed char int_1;
  typedef unsigned char uint_1;
  typedef int int_4;
  typedef unsigned int uint_4;
  typedef short int_2;
  typedef unsigned short uint_2;
  typedef float r_4;
  typedef double r_8;
  typedef long long int_8;
  typedef unsigned long long uint_8;

#define  SWAP 0
#define  SWAPDEFAUT   0

/* Check linux on other machines than Intel */
#elif defined(OS_LINUX)

  typedef signed char int_1;
  typedef unsigned char uint_1;
  typedef int int_4;
  typedef unsigned int uint_4;
  typedef short int_2;
  typedef unsigned short uint_2;
  typedef float r_4;
  typedef double r_8;
  typedef long long int_8;
  typedef unsigned long long uint_8;

#define  SWAP 1
#define  SWAPDEFAUT   1

#elif defined(OS_MACOS)

  typedef signed char int_1;
  typedef unsigned char uint_1;
  typedef long int_4;
  typedef unsigned long uint_4;
  typedef short int_2;
  typedef unsigned short uint_2;
  typedef float r_4;
  typedef double r_8;
  typedef long long int_8;
  typedef unsigned long long uint_8;

#define  SWAP 0
#define  SWAPDEFAUT   0

#else
#error  Undefined Machine/OS type in machdefs.h
#endif



#if SWAP==1
#define IS_BIG_ENDIAN 0
#else
#define IS_BIG_ENDIAN 1
#endif


/***********************************************************************/
/* Find Compiler                                                       */
/***********************************************************************/

/*    __MWERKS__   : Metrowerks Codewarrior (>= PRO 4)                 */
/*    __DECCXX     : DEC CXX, version >= 6 is required                 */
/*    __GNUG__     : GNU C++ 2.8.1, egcs ??                            */
/*    __aCC__      : aCC on HP                                         */
/*    __KCC__      : KCC, version >= 3.3 is required                   */

/***********************************************************************/
/* Compiler-specific stuff                                             */
/***********************************************************************/

/* Some features will be *required* for Planck. Which ones ?               */
  
/*   ANSI_TEMPLATES        : use ANSI syntax for explicit templates        */
/*   GNUG_TEMPLATES        : use GNU syntax for explicit templates         */
/*   PRAGMA_TEMPLATES      : use pragma template, a la cxx                 */
/*   COMPILER_EXCEPTIONS   : knows about exceptions  --- required ?        */ 
/*   STREAMPOS_IS_CLASS    : streampos is a real class                     */
/*   ITER_TAG              : use iter_tag for iterator qualifiers in STL   */
/*   NO_STRSTREAM          : does not have strstream                       */
/*   HAS_EXPLICIT          : knows about explicit keyword - constructors   */
/*   HAS_IOS_BIN                                                           */
/*   HAS_IOS_NOCREATE                                                      */
/*   HAS_VEC_NEW           : operator new[]                                */
/*   ANSI_IO               : rdbuf()->pubseekoff rather than seekg         */
/*   HAS_STR_NPOS          : has string::npos and not a global NPOS        */
/*   NO_IOS_COMPLEX        : does not have operator << defined for complex */


/* The following is true for most compilers */

#ifndef HAS_VEC_NEW
#define HAS_VEC_NEW
#endif

#ifndef COMPILER_EXCEPTIONS
#define COMPILER_EXCEPTIONS
#endif

/* now the specific things */

#ifdef __MWERKS__
#define ANSI_TEMPLATES
#undef  HAS_VEC_NEW
#define NO_STRSTREAM
#define STREAMPOS_IS_CLASS
#define ITER_TAG
#define HAS_IOS_BIN 
#define HAS_IOS_NOCREATE 
#define HAS_STR_NPOS
#endif

#ifdef __GNUG__
#define GNU_TEMPLATES
#define HAS_STR_NPOS
#define HAS_EXPLICIT
#define HAS_IOS_BIN
#define HAS_IOS_NOCREATE
#endif

#ifdef __DECCXX
#define HAS_STR_NPOS
#define ITER_TAG
#define __CXX_PRAGMA_TEMPLATES__
#define PRAGMA_TEMPLATES
#endif

#if defined (__aCC__)  
#ifndef COMPILER_EXCEPTIONS
#define COMPILER_EXCEPTIONS
#endif
#ifndef ANSI_TEMPLATES
#define ANSI_TEMPLATES
#endif
#endif

#if defined(__KCC__)
/* KCC V 3.2 ne compile pas  i/ostream s ; long p = s.tellg();  OK en  V 3.3 */
#define STREAMPOS_IS_CLASS
#define HAS_STR_NPOS
#ifndef COMPILER_EXCEPTIONS
#define COMPILER_EXCEPTIONS
#endif
#ifndef ANSI_TEMPLATES
#define ANSI_TEMPLATES
#endif
#endif


/* Get things has homogeneous as possible between compilers */

#ifdef HAS_STR_NPOS
#define NPOS string::npos
#else
#define NPOS (size_t)-1
#endif

#ifndef __GNUG__
#define __PRETTY_FUNCTION__ __FILE__ " __LINE__ "
#ifndef __FUNCTION__
#define __FUNCTION__ __FILE__ " __LINE__ "
#endif
#ifndef __KCC__
#define __attribute__(_x_)
#endif
#endif

#ifndef HAS_EXPLICIT
#define explicit
#endif

#ifdef HAS_IOS_BIN
#define IOS_BIN ios::binary
#else
#define IOS_BIN 0
#endif

#ifdef ANSI_IO
#define seekg(p_, m_) rdbuf()->pubseekoff(p_,m_)
#define seekp(p_, m_) rdbuf()->pubseekoff(p_,m_)
#endif

#ifdef __MWERKS__
//#define hypot(_x_,_y_) sqrt((_x_)*(_x_) + (_y_)*(_y_))
#define random() (rand()*65538.0 + rand()*2. + rand())
#define srandom srand
#define initstate(seed, tab, n) srand(seed)
#define nice(_x)

#ifdef __cplusplus
#include <string.h>
#include <string>
inline bool operator< (string const& s1, string const& s2)
{ return (strcmp(s1.c_str(), s2.c_str()) < 0); }
#endif
#endif


/********************************************************/
/* Outil d'impressions pour debug */
#define PR(_data_)  {cout<<" "<<#_data_<<" "<<_data_;}
#define CR {cout<<"\n"<<flush;}
/* ********************************************************/

/* Compatibilite, avant de migrer tout le code en "PLANCK" */

#ifdef __cplusplus
namespace PlanckDPC {}
using namespace PlanckDPC;
#define EXPLICIT explicit
#include "pclassids.h"
#endif

#endif
