// This may look like C code, but it is really -*- C++ -*-
// Gestion de block de donnees avec partage de references
//                         C.Magneville          04/99
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA
#ifndef NDATABLOCK_H
#define NDATABLOCK_H

#include "machdefs.h"
#include "anydataobj.h"
#include <iostream.h>

namespace PlanckDPC {

// Classe pour permettre de partager des donnees avec 
// un autre systeme de gestion de references (ex avec Blitz)
class Bridge {
public:
  Bridge() { } 
  virtual ~Bridge() { }
};

// classe de container avec partage de reference
template <class T>
class NDataBlock : public AnyDataObj {

public:

  // Creation / destruction 
  NDataBlock(size_t n);
  NDataBlock(size_t n, T* data, Bridge* br=NULL);
  NDataBlock();
  NDataBlock(const NDataBlock<T>& a);
  NDataBlock(const NDataBlock<T>& a,bool share);
  virtual ~NDataBlock();

  // Temporaire?
  inline bool IsTemp(void) const {return mIsTemp;}
  void SetTemp(bool temp=false) const;

  // Gestion taille/Remplissage
  void Clone(const NDataBlock<T>& a);
  void Reset(T v=0);
  void ReSize(size_t n);
  void FillFrom(size_t n,T* data);
  
  // Informations pointeur/data
  inline T* Data()
         {if(mSRef) return mSRef->data; else return NULL;}
  inline T* Data() const
         {if(mSRef) return mSRef->data; else return NULL;}
  inline size_t Size() const    {return mSz;}
  inline T& operator()(size_t i)       {return *(mSRef->data+i);}
  inline T  operator()(size_t i) const {return *(mSRef->data+i);}

  inline T*        Begin()        {return mSRef->data;}
  inline T const*  Begin() const  {return mSRef->data;} 
  inline T*        End()          {return mSRef->data+mSz;}
  inline T const*  End() const    {return mSRef->data+mSz;}

  // Impression
  void Print(ostream& os, size_t i1=0,size_t n=10) const;
  inline void Print(size_t i1=0,size_t n=0) const {Print(cout,i1,n);}

  //
  T Sum(size_t i1=0,size_t n=0) const;
  T Product(size_t i1=0,size_t n=0) const;

  // Surcharge d operateurs
  NDataBlock<T>& operator = (const NDataBlock<T>& a);
  NDataBlock<T>& operator = (T v);

  NDataBlock<T>& operator += (T b);
  NDataBlock<T>& operator -= (T b);
  NDataBlock<T>& operator *= (T b);
  NDataBlock<T>& operator /= (T b);

  NDataBlock<T>& operator += (const NDataBlock<T>& a);
  NDataBlock<T>& operator -= (const NDataBlock<T>& a);
  NDataBlock<T>& operator *= (const NDataBlock<T>& a);
  NDataBlock<T>& operator /= (const NDataBlock<T>& a);

  NDataBlock<T> Add(T b) const;
  NDataBlock<T> Sub(T b) const;
  NDataBlock<T> SubInv(T b) const;
  NDataBlock<T> Mul(T b) const;
  NDataBlock<T> Div(T b) const;
  NDataBlock<T> DivInv(T b) const;

  NDataBlock<T> Add(const NDataBlock<T>& b) const;
  NDataBlock<T> Sub(const NDataBlock<T>& b) const;
  NDataBlock<T> SubInv(const NDataBlock<T>& b) const;
  NDataBlock<T> Mul(const NDataBlock<T>& b) const;
  NDataBlock<T> Div(const NDataBlock<T>& b) const;
  NDataBlock<T> DivInv(const NDataBlock<T>& b) const;

protected:

  typedef struct {size_t nref; T* data; Bridge* bridge; } NDREF;

  void Alloc(size_t n,T* data=NULL,Bridge* br=NULL);
  void Share(const NDataBlock<T>& a);
  void Delete(void);

  size_t   mSz;
  NDREF*   mSRef;
  mutable bool     mIsTemp;
};


template<class T>
inline ostream& operator << (ostream& os, const NDataBlock<T>& a)
                      {Print(os); return(os);}
template<class T>
inline NDataBlock<T> operator + (const NDataBlock<T>& a,T b)
                      {return a.Add(b);}
template<class T>
inline NDataBlock<T> operator + (T b,const NDataBlock<T>& a)
                      {return a.Add(b);}
template<class T>
inline NDataBlock<T> operator - (const NDataBlock<T>& a,T b)
                      {return a.Sub(b);}
template<class T>
inline NDataBlock<T> operator - (T b,const NDataBlock<T>& a)
                      {return a.SubInv(b);}
template<class T>
inline NDataBlock<T> operator * (const NDataBlock<T>& a,T b)
                      {return a.Mul(b);}
template<class T>
inline NDataBlock<T> operator * (T b,const NDataBlock<T>& a)
                      {return a.Mul(b);}
template<class T>
inline NDataBlock<T> operator / (const NDataBlock<T>& a,T b)
                      {return a.Div(b);}
template<class T>
inline NDataBlock<T> operator / (T b,const NDataBlock<T>& a)
                      {return a.DivInv(b);}

template<class T>
inline NDataBlock<T> operator + (const NDataBlock<T>& a,const NDataBlock<T>& b)
                      {return a.Add(b);}
template<class T>
inline NDataBlock<T> operator - (const NDataBlock<T>& a,const NDataBlock<T>& b)
                      {return a.Sub(b);}
template<class T>
inline NDataBlock<T> operator * (const NDataBlock<T>& a,const NDataBlock<T>& b)
                      {return a.Mul(b);}
template<class T>
inline NDataBlock<T> operator / (const NDataBlock<T>& a,const NDataBlock<T>& b)
                      {return a.Div(b);}

} // Fin du namespace

#endif
