#include "sopnamsp.h"
#include "machdefs.h"
#include <stdlib.h>
#include <typeinfo>
#include <iostream>
#include <string>

#include "datatype.h"

#include "nomimagadapter.h"
#include "pimgadapter.h"

#ifdef SANS_EVOLPLANCK
#include "fitsimage.h"
#else
#include "objfitter.h"
#include "fitstarray.h"
#endif



//---------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet Image<T> 
//---------------------------------------------------------------


/* --Methode-- */
template <class T>
NOMAdapter_Image<T>::NOMAdapter_Image(Image<T> * o)
  : NObjMgrAdapter(o)
{
mImg = o;
}

/* --Methode-- */
template <class T>
NOMAdapter_Image<T>::~NOMAdapter_Image()
{
}

/* --Methode-- */
template <class T>
NObjMgrAdapter* NOMAdapter_Image<T>::Clone(AnyDataObj* o)
{
Image<T>* im = dynamic_cast<Image<T> *>(o);
if (im) return ( new NOMAdapter_Image<T>(im) );
return ( new NObjMgrAdapter(o) );
}

/* --Methode-- */
template <class T> 
string NOMAdapter_Image<T>::GetDataObjType()
{
string type = "Image< ";
// type +=  DecodeTypeIdName(typeid(T).name());
type += DataTypeInfo<T>::getTypeName();
type +=  " > ";
return(type);
}

/* --Methode-- */
template <class T>
AnyDataObj* NOMAdapter_Image<T>::CloneDataObj(bool share)
{
#ifdef SANS_EVOLPLANCK
FitsImage<T> * fima = dynamic_cast<FitsImage<T> *>(mImg);
if (fima == NULL)   return( new Image<T>(*mImg ) );
else return ( new FitsImage<T>(*fima) );
#else
return( new Image<T>(*mImg, share) );
#endif
}

/* --Methode-- */
template <class T>
void NOMAdapter_Image<T>::ReadFits(string const & flnm)
{
#ifdef SANS_EVOLPLANCK
  cerr << " NOMAdapter_Image<T>::ReadFits() Non disponible !! " << endl;
#else
  FitsInFile fis(flnm);
  fis >> (*mImg);
#endif
}

/* --Methode-- */
template <class T>
void NOMAdapter_Image<T>::SaveFits(string const & flnm)
{
#ifdef SANS_EVOLPLANCK
FitsImage<T> fim(*mImg, 1);
fim.Save(flnm);
#else
  FitsOutFile fos(flnm);
  fos << (*mImg);
#endif
}

#ifndef SANS_EVOLPLANCK
DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
void NOMAdapter_Image< uint_2 >::SaveFits(string const & flnm)
{
cout << " NOMAdapter_Image< uint_2 >::SaveFits() - Error " 
     << " Not supported uint_2 data type ! " << endl;
}

DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
void NOMAdapter_Image< uint_2 >::ReadFits(string const & flnm)
{
cout << " NOMAdapter_Image< uint_2 >::ReadFits() - Error " 
     << " Not supported uint_2 data type ! " << endl;
}
#endif

/* --Methode-- */
template <class T>
void NOMAdapter_Image<T>::SavePPF(POutPersist& pos, string const & nom)
{
#ifdef SANS_EVOLPLANCK
// PEIDA-EROS L'histo est lui-meme PPersist
string tag = nom;  // A cause de const
mImg->Write(pos,0,tag);
#else
string s = typeid(*mObj).name();
cout << "NOMAdapter_Image<T>::SavePPF() - Error : Not supported for " << s << endl;
#endif
}

/* --Methode-- */
template <class T>
void NOMAdapter_Image<T>::Print(ostream& os)
{
mImg->Print(os);
}


/* --Methode-- */
template <class T>
P2DArrayAdapter* NOMAdapter_Image<T>::Get2DArray(string &)
{
return ( new ImageAdapter<T>(mImg, false) );
}

/* --Methode-- */
template <class T>
NTupleInterface* NOMAdapter_Image<T>::GetNTupleInterface(bool& adel)
{
adel = true;
return( new NTupInt_Image<T>(mImg) );
}

/* --Methode-- */
template <class T>
GeneralFitData* NOMAdapter_Image<T>::GetGeneralFitData(bool& adel
 ,GeneralFitData::FitErrType errtype,double errscale,double errmin
 ,int i1,int i2,int j1,int j2)
{
adel = false;
if(!mImg) return(NULL);

int nx = mImg->XSize();
int ny = mImg->YSize();
if(nx<=0 || ny<=0) return(NULL);

i1 = (i1<0||i1>=nx)? 0: i1;
i2 = (i2<0||i2>=nx||i2<i1)? nx-1: i2;
j1 = (j1<0||j1>=ny)? 0: j1;
j2 = (j2<0||j2>=ny||j2<j1)? ny-1: j2;

GeneralFitData* mGData = new GeneralFitData(2,(i2-i1+1)*(j2-j1+1),0);
adel = true;

for(int i=i1;i<=i2;i++) for(int j=j1;j<=j2;j++) {
  double x = mImg->XPos(i);
  double y = mImg->YPos(j);
  double f = (*mImg)(i,j);
  double e = 1.;
  e = GeneralFitData::ComputeError(f,e,errtype,errscale,errmin);
  mGData->AddData2(x,y,f,e);
}

return mGData;
}

template <class T>
AnyDataObj* NOMAdapter_Image<T>::FitResidusObj(GeneralFit& mfit)
{
#ifdef SANS_EVOLPLANCK
RzImage* rzim = mImg->FitResidus(mfit);  
ImageR4* im   = new ImageR4(*rzim);
return im;
#else
Image<T>* im = new Image<T>(ObjectFitter::FitResidus(*mImg,mfit));
return im;
#endif
}

template <class T>
AnyDataObj* NOMAdapter_Image<T>::FitFunctionObj(GeneralFit& mfit)
{
#ifdef SANS_EVOLPLANCK
RzImage* rzim = mImg->FitFunction(mfit);  
ImageR4* im   = new ImageR4(*rzim);
return im;
#else
Image<T>* im = NULL;
//im = new Image<T>(ObjectFitter::FitFunction(*mImg,mfit));
return im;
#endif
}


// -------------------------------------------------------------

/* --Methode-- */
template <class T>
NTupInt_Image<T>::NTupInt_Image(Image<T>* m)
{
mImg = m;
}

/* --Methode-- */
template <class T>
NTupInt_Image<T>::~NTupInt_Image()
{
}

/* --Methode-- */
template <class T>
sa_size_t NTupInt_Image<T>::NbLines() const 
{
return( mImg->XSize() * mImg->YSize() );
}

/* --Methode-- */
template <class T>
sa_size_t NTupInt_Image<T>::NbColumns() const 
{
return(3);
}

/* --Methode-- */
template <class T>
r_8* NTupInt_Image<T>::GetLineD(sa_size_t n) const 
{
int i,j;
if ((n < 0) || (n >= mImg->XSize() * mImg->YSize() )) 
    for(i=0; i<3; i++)  mRet[i] = 0.;
else { 
  i = n%mImg->XSize();  j = n/mImg->XSize(); 
  mRet[0] = i;  mRet[1] = j;  mRet[2] = (*mImg)(i,j);
  }
return(mRet);
}

/* --Methode-- */
template <class T>
string NTupInt_Image<T>::VarList_C(const char* nx) const 
{
string nomx;
if (nx) nomx = nx;
else nomx = "_xh_";
string vardec = "double x,y,pix,i,j,val; \n";
vardec += "x = i = " + nomx + "[0]; y = j = " + nomx + "[1];  pix = val = " + nomx + "[2]; \n";
return(vardec);
}

#ifdef __CXX_PRAGMA_TEMPLATES__
#pragma define_template NOMAdapter_Image<uint_2>
#pragma define_template NOMAdapter_Image<int_4>
#pragma define_template NOMAdapter_Image<r_4>
#pragma define_template NTupInt_Image<uint_2>
#pragma define_template NTupInt_Image<int_4>
#pragma define_template NTupInt_Image<r_4>
#ifdef SANS_EVOLPLANCK
#pragma define_template NOMAdapter_Image<int_2>
#pragma define_template NTupInt_Image<int_2>
#endif
#endif
#if defined(ANSI_TEMPLATES) || defined(__ANSI_TEMPLATES__) || defined(__GNU_TEMPLATES__) 
template class NOMAdapter_Image<uint_2>;
template class NOMAdapter_Image<int_4>;
template class NOMAdapter_Image<r_4>;
template class NTupInt_Image<uint_2>;
template class NTupInt_Image<int_4>;
template class NTupInt_Image<r_4>;
#ifdef SANS_EVOLPLANCK
template class NOMAdapter_Image<int_2>;
template class NTupInt_Image<int_2>;
#endif
#endif


