// This may look like C code, but it is really -*- C++ -*-
// Adaptateur d objets (pour NamedObjMgr) pour Histos/NTuple
//                                    Reza 05/99
//  LAL-IN2P3/CNRS               CEA-DAPNIA     
 
#ifndef NOMMATVECADAPTER_H_SEEN
#define NOMMATVECADAPTER_H_SEEN

#include "nomgadapter.h"
#include "generalfit.h"

#ifdef SANS_EVOLPLANCK
#include "matrix.h"
#include "cvector.h"
#else
#include "tmatrix.h"
#include "tvector.h"
#endif

//---------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet Vector 
//---------------------------------------------------------------

class NOMAdapter_Vector : public NObjMgrAdapter {
public:
				NOMAdapter_Vector(Vector* v = NULL);
  virtual			~NOMAdapter_Vector();

  virtual NObjMgrAdapter*	Clone(AnyDataObj* o);

  virtual string		GetDataObjType();

  virtual AnyDataObj*		CloneDataObj(bool share=false);

  //  virtual void			ReadFits(string const & flnm);
  //  virtual void			SaveFits(string const & flnm);
  virtual void			SavePPF(POutPersist& s, string const & nom);

  virtual void			Print(ostream& os);
  virtual PIDrawer*		GetDrawer(string& dopt);
  virtual NTupleInterface*	GetNTupleInterface(bool& adel);

  virtual GeneralFitData* GetGeneralFitData(bool& adel
          ,GeneralFitData::FitErrType errtype=GeneralFitData::DefaultError
          ,double errscale=1.,double errmin=0.
          ,int i1=0,int i2=-1,int j1=0,int j2=-1);
  virtual AnyDataObj* FitResidusObj(GeneralFit& mfit);
  virtual AnyDataObj* FitFunctionObj(GeneralFit& mfit);

protected:
  Vector* mVec;
};

// Class Interface NTuple pour Vector
class NTupInt_Vector : public NTupleInterface {
public:
			NTupInt_Vector(Vector* v);
  virtual		~NTupInt_Vector();
  virtual sa_size_t     NbLines() const ;
  virtual sa_size_t     NbColumns() const ;
  virtual r_8 *         GetLineD(sa_size_t n) const ;
  virtual string        VarList_C(const char* nomx=NULL) const ;
protected:
  Vector* mVec;
  mutable r_8 mRet[2];
};



//---------------------------------------------------------------
// Class Adaptateur d'objet (Pour NamedObjMgr) d'objet Matrix 
//---------------------------------------------------------------

class NOMAdapter_Matrix : public NObjMgrAdapter {
public:
				NOMAdapter_Matrix(Matrix* m = NULL);
  virtual			~NOMAdapter_Matrix();

  virtual NObjMgrAdapter*	Clone(AnyDataObj* o);

  virtual string		GetDataObjType();

  virtual AnyDataObj*		CloneDataObj(bool share=false);

  //  virtual void			ReadFits(string const & flnm);
  //  virtual void			SaveFits(string const & flnm);
  virtual void			SavePPF(POutPersist& s, string const & nom);

  virtual void			Print(ostream& os);
  virtual P2DArrayAdapter*	Get2DArray(string& dopt);
  virtual NTupleInterface*	GetNTupleInterface(bool& adel);

  virtual GeneralFitData* GetGeneralFitData(bool& adel
          ,GeneralFitData::FitErrType errtype=GeneralFitData::DefaultError
          ,double errscale=1.,double errmin=0.
          ,int i1=0,int i2=-1,int j1=0,int j2=-1);
  virtual AnyDataObj* FitResidusObj(GeneralFit& mfit);
  virtual AnyDataObj* FitFunctionObj(GeneralFit& mfit);

protected:
  Matrix* mMtx;
};

// Class Interface NTuple pour Matrix

class NTupInt_Matrix : public NTupleInterface {
public:
			NTupInt_Matrix(Matrix* m);
  virtual		~NTupInt_Matrix();
  virtual sa_size_t     NbLines() const ;
  virtual sa_size_t     NbColumns() const ;
  virtual r_8 *         GetLineD(sa_size_t n) const ;
  virtual string        VarList_C(const char* nomx=NULL) const ;
protected:
  Matrix* mMtx;
  mutable r_8 mRet[3];
};


#endif
