// This may look like C code, but it is really -*- C++ -*-
//  Classe pour faciliter entree-sortie PPF pour des pointeurs
//       R. Ansari -  Mars 2005

#ifndef PPFTPOINTERIO_H_SEEN
#define PPFTPOINTERIO_H_SEEN

#include "ppersist.h"

//----------------------------------------------------------------------
namespace SOPHYA {

/*!
  \class SOPHYA::PPF_TPointer_IO
  \ingroup BaseTools
  A template utility class with static methods to ease handling of array 
  I/O in PPF streams (POutPersist and PInPersist). It is not intented for
  direct use in user programs, but for writing PPF persistence handler 
  classes (PPersist). 
  The C++ I/O operators POutPersist& << and PInPersist& >> should be defined for
  new types and classes.
*/

template <class T>
class PPF_TPointer_IO {
public:
  //! Writes the array pointed to by \b arr (size \b n) to POutPersist stream \b os
  static void Write(POutPersist & os,  T  const * arr, size_t n)
  {
    for(size_t k=0; k<n; k++) os << arr[k];
  }
  //! Reads from the PInPersist \b is into array pointed to by \b arr (size \b n)
  static void Read(PInPersist & is, T * arr, size_t n)
  {
    for(size_t k=0; k<n; k++) is >> arr[k];
  }
};


}  // namespace SOPHYA

#endif   /* PPFTPOINTERIO_H_SEEN */
