// This may look like C code, but it is really -*- C++ -*-
// Class BaseDataTable 
//   R. Ansari -  Avril 2005
//   (C)  LAL-IN2P3/CNRS    CEA-DAPNIA  

#ifndef BASEDTABLE_H_SEEN
#define BASEDTABLE_H_SEEN

#include "machdefs.h"

#include <iostream>
#include <string>
#include <vector>

#include "ntupintf.h"
#include "dvlist.h"
#include "segdatablock.h"

namespace SOPHYA {
class BaseDataTable : public AnyDataObj , public NTupleInterface {
public:
  // ===> DO NOT CHANGE EXISTING enum type VALUES !!! 
  enum FieldType {IntegerField=1, LongField=2, 
		  FloatField=3, DoubleField=4,
		  ComplexField=5, DoubleComplexField=6,
		  StringField=7, DateField=8};
  // <=====================================================> 

  static string     ColTypeToString(FieldType ft, bool fgl=false);

  // constructeur , destructeur 
  BaseDataTable(sa_size_t segsz=512);
  virtual           ~BaseDataTable();
  
  inline sa_size_t  AddIntegerColumn(const char * cnom) 
  { return AddColumn(IntegerField, cnom); }
  inline sa_size_t  AddIntegerColumn(string const & cnom) 
  { return AddColumn(IntegerField, cnom); }
  inline sa_size_t  AddFloatColumn(const char * cnom) 
  { return AddColumn(FloatField, cnom); }
  inline sa_size_t  AddFloatColumn(string const & cnom) 
  { return AddColumn(FloatField, cnom); }
  inline sa_size_t  AddDoubleColumn(const char * cnom) 
  { return AddColumn(DoubleField, cnom); }
  inline sa_size_t  AddDoubleColumn(string const & cnom) 
  { return AddColumn(DoubleField, cnom); }
  
  inline sa_size_t  AddColumn(FieldType ft, const char * cnom)
  { string nom = cnom;  return AddColumn(ft, nom); }
  
  //! Pure virtual method for adding a new column to the Data Table
  virtual sa_size_t AddColumn(FieldType ft, string const & cnom) = 0;
  //! Duplicate the data table structure from the source Table
  virtual sa_size_t CopyStructure(BaseDataTable const & a);
  //! Checks if the two table have the same column structure
  virtual bool      CompareStructure(BaseDataTable const & a);

  // Verifie la validite du nom de colonne:envoie une exception
  // si nom en double ou non valide
  virtual bool      CheckColName(string const & cnom);

  // Acces to various counts and parameters
  inline sa_size_t  NEntry() const { return mNEnt ; }
  inline sa_size_t  NVar() const   { return mNames.size() ; } 
  inline sa_size_t  NVars() const   { return mNames.size() ; } 
  inline sa_size_t  SegmentSize() const   { return mSegSz ; } 
  inline sa_size_t  NbSegments() const   { return mNSeg ; } 

  // Filling data structures (adding lines)
  virtual sa_size_t AddLine(const r_8* data);
  virtual sa_size_t AddLine(const MuTyV * data);
  
  inline sa_size_t  Fill(const r_8* data)
  { return AddLine(data); }
  inline sa_size_t  Fill(const MuTyV * data);
     
  virtual sa_size_t Extend();

  // Getting a given line (record) information 
  virtual MuTyV *   GetLine(sa_size_t n) const ;
  
  sa_size_t         IndexNom(char const* nom) const ; 
  inline sa_size_t  IndexNom(string const & nom) const 
  { return IndexNom(nom.c_str()); }
  string            NomIndex(sa_size_t k) const ; 
  
  //! Copy or merges  the data from \b a into the data table (cp=true -> copy)
  virtual void      CopyMerge(BaseDataTable const& a, bool cp=false) ; 
  //! Equal (copy) operator
  inline BaseDataTable&  operator = (BaseDataTable const& a) 
  { CopyMerge(a, true) ; return *this ; } 
   
  void              Print(int num, int nmax=1) const ;
  
  void              Show(ostream& os) const ; 
  inline void       Show() const { Show(cout) ; } 
  
  DVList&           Info() const ; 
  
  // Remplissage depuis fichier ASCII 
  int		    FillFromASCIIFile(string const& fn);
  
  // Declaration de l interface NTuple
  virtual sa_size_t NbLines() const ;
  virtual sa_size_t NbColumns() const ;
  virtual r_8 *     GetLineD(sa_size_t n) const ;
  virtual r_8	    GetCell(sa_size_t n, sa_size_t k) const ;
  virtual r_8	    GetCell(sa_size_t n, string const & nom) const ;
  virtual string    GetCelltoString(sa_size_t n, sa_size_t k) const ;
  virtual void      GetMinMax(sa_size_t k, double& min, double& max)   const ; 
  virtual void      GetMinMax(string const & nom, double& min, double& max)   const ; 
  virtual sa_size_t ColumnIndex(string const & nom)  const ;
  virtual string    ColumnName(sa_size_t k) const;
  virtual string    VarList_C(const char* nomx=NULL) const ;
  virtual string    LineHeaderToString() const;
  virtual string    LineToString(sa_size_t n) const;  
  
protected:
  uint_8   mNEnt ;   // nb total d'entrees 
  uint_8   mSegSz ;  // taille bloc/segment 
  uint_8   mNSeg;    // Nb total de segments
  mutable r_8 *  mVarD;    // Pour retourner une ligne de la table
  mutable MuTyV *  mVarMTV;    // Pour retourner une ligne de la table en MuTyV
  
  typedef struct { 
    string nom; 
    FieldType type;
    sa_size_t ser;
  } colst;
  std::vector<colst> mNames;

  mutable DVList* mInfo;        // Infos (variables) attachees au NTuple

  // Pour calculer et garder le min/max   
  mutable std::vector<r_8> mMin;
  mutable std::vector<r_8> mMax;
  mutable std::vector<uint_8> mMinMaxNEnt;
  
  // Les pointeurs des SegDataBlock ...  
  std::vector< SegDBInterface<int_4> * > mIColsP; 
  std::vector< sa_size_t > mIColIdx;
  std::vector< SegDBInterface<int_8> * > mLColsP; 
  std::vector< sa_size_t > mLColIdx;
  std::vector< SegDBInterface<r_4> * > mFColsP;
  std::vector< sa_size_t > mFColIdx; 
  std::vector< SegDBInterface<r_8> * > mDColsP; 
  std::vector< sa_size_t > mDColIdx;
  std::vector< SegDBInterface<string> * > mSColsP; 
  std::vector< sa_size_t > mSColIdx;
  
}; 
/*! Prints table information (Column name and type, min/max) on stream \b s (bd.Show(s)) */
inline ostream& operator << (ostream& s, BaseDataTable const & bd)
  {  bd.Show(s);  return(s);  }
  
} // namespace SOPHYA

#endif
