// This may look like C code, but it is really -*- C++ -*-
// Class DataTable  (Row-Column data table in memory) 
//   R. Ansari -  Avril 2005
//   (C)  LAL-IN2P3/CNRS    CEA-DAPNIA  

#ifndef SWPPFDTABLE_H_SEEN
#define SWPPFDTABLE_H_SEEN

#include "basedtable.h"
#include "swsegdb.h"
#include "ppfswapper.h"
#include "objfio.h"


namespace SOPHYA {

class SwPPFDataTable : public BaseDataTable {
public:
  SwPPFDataTable(sa_size_t segsz=512);
  SwPPFDataTable(POutPersist & os, sa_size_t segsz=512); 
  SwPPFDataTable(SwPPFDataTable const& a); 
  
  virtual sa_size_t AddColumn(FieldType ft, string const & cnom);

  // Filling data structures (adding lines)
  virtual sa_size_t AddLine(const r_8* data);
  virtual sa_size_t AddLine(const MuTyV * data);

  //! Equal (copy) operator - Copies the structure and shares the data \b a   
  inline SwPPFDataTable& operator = (SwPPFDataTable const& a) 
  { Clear(); Share(a); return *this ; } 

  //  Pour la gestion de persistance PPF
  friend class ObjFileIO<SwPPFDataTable> ;
  
  //! Reset the table content and structure
  void Clear();
  /*! This method should be called in order to empty the swapout buffer, 
     before saving object to PPF stream 
  */
  void SwapOutAll() const;
protected:
  SwPPFDataTable(PInPersist & is, sa_size_t segsz); 
  void Share(SwPPFDataTable const & a);

  // Donnees en memoire
  std::vector< SwSegDataBlock<int_4> > mICols; 
  PPFDataSwapper<int_4> mISwapper;
  std::vector< SwSegDataBlock<int_8> > mLCols; 
  PPFDataSwapper<int_8> mLSwapper;
  std::vector< SwSegDataBlock<r_4> > mFCols;
  PPFDataSwapper<r_4> mFSwapper;
  std::vector< SwSegDataBlock<r_8> > mDCols; 
  PPFDataSwapper<r_8> mDSwapper;
  std::vector< SwSegDataBlock<string> > mSCols;    
  PPFDataSwapper<string> mSSwapper;
 
  POutPersist* mSwOut;
  PInPersist* mSwIn;
}; 
  
/*! Writes the object in the POutPersist stream \b os */
inline POutPersist& operator << (POutPersist& os, SwPPFDataTable & obj)
{ obj.SwapOutAll();  ObjFileIO<SwPPFDataTable> fio(&obj);  fio.Write(os);  return(os); }
/*! Reads the object from the PInPersist stream \b is */
inline PInPersist& operator >> (PInPersist& is, SwPPFDataTable & obj)
{  ObjFileIO<SwPPFDataTable> fio(&obj); is.SkipToNextObject(); fio.Read(is); return(is); }
// Classe pour la gestion de persistance
// ObjFileIO<SwPPFDataTable>
} // namespace SOPHYA

#endif

