// This may look like C code, but it is really -*- C++ -*-
//  Classe pour faciliter entree-sortie PPF pour des pointeurs
//       R. Ansari -  Mars 2005

#ifndef PPFTPOINTERIO_H_SEEN
#define PPFTPOINTERIO_H_SEEN

#include "ppersist.h"

//----------------------------------------------------------------------
namespace SOPHYA {

/*!
  \class SOPHYA::PPF_TPointer_IO
  \ingroup BaseTools
  A template utility class with static methods to ease handling of array 
  I/O in PPF streams (POutPersist and PInPersist). It is not intented for
  direct use in user programs, but for writing PPF persistence handler 
  classes (PPersist). 
  The C++ I/O operators POutPersist& << and PInPersist& >> should be defined for
  new types and classes.
*/

template <class T>
class PPF_TPointer_IO {
public:
  //! Writes the array pointed to by \b arr (size \b n) to POutPersist stream \b os
  static void Write(POutPersist & os,  T  const * arr, size_t n)
  {
    for(size_t k=0; k<n; k++) os << arr[k];
  }
  //! Reads from the PInPersist \b is into array pointed to by \b arr (size \b n)
  static void Read(PInPersist & is, T * arr, size_t n)
  {
    for(size_t k=0; k<n; k++) is >> arr[k];
  }
};

// declaration specifique pour ecriture sous forme de tableaux PPF
DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
class PPF_TPointer_IO<char> {
public:
  static void Write(POutPersist & os,  char  const * arr, size_t n);
  static void Read(PInPersist & is, char * arr, size_t n);
};

DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
class PPF_TPointer_IO<int_1> {
public:
  static void Write(POutPersist & os,  int_1  const * arr, size_t n);
  static void Read(PInPersist & is, int_1 * arr, size_t n);
};
DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
class PPF_TPointer_IO<uint_1> {
public:
  static void Write(POutPersist & os,  uint_1  const * arr, size_t n);
  static void Read(PInPersist & is, uint_1 * arr, size_t n);
};

DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
class PPF_TPointer_IO<int_2> {
public:
  static void Write(POutPersist & os,  int_2  const * arr, size_t n);
  static void Read(PInPersist & is, int_2 * arr, size_t n);
};
DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
class PPF_TPointer_IO<uint_2> {
public:
  static void Write(POutPersist & os,  uint_2  const * arr, size_t n);
  static void Read(PInPersist & is, uint_2 * arr, size_t n);
};

DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
class PPF_TPointer_IO<int_4> {
public:
  static void Write(POutPersist & os,  int_4  const * arr, size_t n);
  static void Read(PInPersist & is, int_4 * arr, size_t n);
};
DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
class PPF_TPointer_IO<uint_4> {
public:
  static void Write(POutPersist & os,  uint_4  const * arr, size_t n);
  static void Read(PInPersist & is, uint_4 * arr, size_t n);
};

DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
class PPF_TPointer_IO<int_8> {
public:
  static void Write(POutPersist & os,  int_8  const * arr, size_t n);
  static void Read(PInPersist & is, int_8 * arr, size_t n);
};
DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
class PPF_TPointer_IO<uint_8> {
public:
  static void Write(POutPersist & os,  uint_8  const * arr, size_t n);
  static void Read(PInPersist & is, uint_8 * arr, size_t n);
};

DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
class PPF_TPointer_IO<r_4> {
public:
  static void Write(POutPersist & os,  r_4  const * arr, size_t n);
  static void Read(PInPersist & is, r_4 * arr, size_t n);
};
DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
class PPF_TPointer_IO<r_8> {
public:
  static void Write(POutPersist & os,  r_8  const * arr, size_t n);
  static void Read(PInPersist & is, r_8 * arr, size_t n);
};

DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
class PPF_TPointer_IO< complex<r_4> > {
public:
  static void Write(POutPersist & os,  complex<r_4>  const * arr, size_t n);
  static void Read(PInPersist & is, complex<r_4> * arr, size_t n);
};
DECL_TEMP_SPEC  /* equivalent a template <> , pour SGI-CC en particulier */
class PPF_TPointer_IO< complex<r_8> > {
public:
  static void Write(POutPersist & os,  complex<r_8>  const * arr, size_t n);
  static void Read(PInPersist & is, complex<r_8> * arr, size_t n);
};

}  // namespace SOPHYA

#endif   /* PPFTPOINTERIO_H_SEEN */
