#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream>

#include "sopnamsp.h"
#include "histinit.h"
#include "ctimer.h"
#include "datatable.h"
#include "swppfdtable.h"

/*  Programme test performances des DataTables / cf G. Barrand    */
/*  R. Ansari (LAL)  -   Avril 2005                    */

static int prtlev = 1;  // niveau d'impression 

void cre_rempli_table(BaseDataTable& dt, sa_size_t nl)
{
  Timer tm("cre_rempli_table");
  cout << " tstdtable/Info: cre_rempli_table() avec nl = " << nl << endl;
  // Ajout de colonnes int + 6 x double
  dt.AddIntegerColumn("i");
  dt.AddDoubleColumn("p1");
  dt.AddDoubleColumn("p2");
  dt.AddDoubleColumn("p3");
  dt.AddDoubleColumn("p4");
  dt.AddDoubleColumn("p5");
  dt.AddDoubleColumn("p6");
  // remplissage :
  MuTyV rec[10];
  //  r_8 rec[10];  Si on veut tout remplir avec des double
  sa_size_t nl10 = nl/10;
  for(sa_size_t k=0; k<nl; k++) {
    rec[0] = (int_4)(k+1);
    rec[1] = (r_8)(k*M_PI);
    rec[2] = (r_8)(2*k*M_PI);
    rec[3] = (r_8)(3*k*M_PI);
    rec[4] = (r_8)(4*k*M_PI);
    rec[5] = (r_8)(5*k*M_PI);
    rec[6] = (r_8)(6*k*M_PI);
    dt.AddLine(rec);    
    if ( (prtlev > 1) && ((k%nl10)==0) )
      cout << "cre_rempli_table/Info fin remplissage ligne " << k << endl;
  }
  tm.Split("cre_rempli_table/fin remplissage");
  // Impression resume de la table :
  if (prtlev > 0) cout << dt ;
  return;
}

void lit_ck_table(BaseDataTable& dt)
{
  cout << " tstdtable/Info: lit_ck_table() - Table: " << endl; 
  if (prtlev > 0) cout << dt;
  if (dt.NEntry() < 1) {
    cout << " tstdtable/Error: Table vide ! " << endl;
    return;
  }
  r_8 mean[10] = {0., 0., 0., 0., 0., 0., 0., 0., 0., 0. };
  r_8* rec;
  sa_size_t nl10 = dt.NEntry()/10;
  for(sa_size_t k=0; k<dt.NEntry(); k++) {
    rec = dt.GetLineD(k);
    for(int i=0; i<7; i++) mean[i] += rec[i];
    if ( (prtlev > 1) && ((k%nl10)==0) )
      cout << "li_ck_table/Info fin check ligne " << k << endl;
  }
  double wtot = dt.NEntry();
  for(int i=0; i<7; i++) { 
    mean[i] /= wtot;
    if (prtlev > 0)    
      cout << " tstdtable/Info: Moyenne[" << i << "]= " << mean[i] << endl;
  }
  return;
}

int main(int narg, char *arg[])
{
  if (narg < 3) {
    cout << " tstdtable/Erreur: arguments manquants \n"
	 << " Usage: tstdtable r/w filename [mem/swap] [Nlines] [segsize] [prtlev] \n" 
	 << "  r : lecture depuis filename - calcule moyenne \n"
	 << "  w : creation / ecriture ds filename \n"
	 << "  NLines: Nombre de lignes de la table si w (defaut=10^6) \n"
	 << "  mem: Utilisation de DataTable (memoire) = defaut \n"
	 << "  swap: Utilisation de SwPPFDataTable (swap sur PPF) \n"
	 << "  segsize: Taille de segment (defaut=1024) \n"
	 << "  prtlev: Niveau d'impression 0,1,2 (defaut=1) \n"
	 << endl;
    return 1;
  }

  try {
    SophyaInit();
    char oper = *arg[1];
    string fname = arg[2];
    sa_size_t nlines = 1000000;
    sa_size_t segsize = 1024;
    string msw = "mem";
    if (narg > 3) msw = arg[3];
    if (narg > 4) nlines = atol(arg[4]);
    if (narg > 5) segsize = atol(arg[5]);
    prtlev = 1;
    if (narg > 6) prtlev = atoi(arg[6]);
   cout << "======== tstdtable: DataTable/G.Barrand test de performance I/O ========" << endl;
    cout << " Operation= " << oper << " FileName= " << fname 
	 << " (NLines= " << nlines << " Mem/Swap= " << msw << " )" << endl;
//----------  Creation , ecriture table
    if (oper == 'w') { 
      if (msw == "mem") {
	Timer tm("DTable:Mem/W");
	cout << "1/ tstdtable/Info: Creation/Ecriture DataTable (memoire) " << endl;
	DataTable dt(segsize);
	cre_rempli_table(dt, nlines);
	tm.Split("Mem/W:Fin-Remplissage");
	cout << "2/ tstdtable/Info: Ecriture DataTable ds " << fname << endl;
	POutPersist so(fname);
	so << dt;
	tm.Split("Mem/W:Fin-PPFWrite");
      }
      else {
	Timer tm("DTable:Swap/W");
	cout << "1/ tstdtable/Info: Creation/Ecriture DataTable (PPFSwap) " << endl;
	POutPersist so(fname);
	SwPPFDataTable dt(so, segsize);
	cre_rempli_table(dt, nlines);
	tm.Split("Swap/W:Fin-Remplissage");
	cout << "2/ tstdtable/Info: Ecriture DataTable ds " << fname << endl;
	so << dt;
	tm.Split("Mem/W:Fin-Ecriture");
      }
    }
//----------  Lecture/verification table
    else {
      if (msw == "mem") {
	Timer tm("DTable:Mem/R");
	cout << "1/ tstdtable/Info: Lecture DataTable (memoire) de " << fname << endl;
	DataTable dt;
	PInPersist si(fname);
	si >> dt;
	tm.Split("Mem/R:Fin-PPFRead");
	cout << "2/ tstdtable/Info: Lecture/verification table " << endl;
	lit_ck_table(dt);
	tm.Split("Mem/R:Fin-CheckLecture");
      }
      else {
	Timer tm("DTable:Swap/R");
	cout << "1/ tstdtable/Info: Lecture DataTable (swap) de " << fname << endl;
	SwPPFDataTable dt;
	PInPersist si(fname);
	si >> dt;
	tm.Split("Swap/R:Fin-PPFRead");
	cout << "2/ tstdtable/Info: Lecture/verification table " << endl;
	lit_ck_table(dt);
	tm.Split("Swap/R:Fin-CheckLecture");
      }
    }

  }
  catch(PThrowable& exc ) {
    cerr << "tstdtable-main() , Catched exception: \n" << exc.Msg() << endl;
  }
  catch(std::exception& ex) {
    cerr << "tstdtable-main() , Catched exception ! " << (string)(ex.what()) << endl;
  }
  catch(...) {
    cerr << "tstdtable-main() , Catched ... ! " << endl;
  }
  cout << "============== tstdtable: DataTable =================" << endl;  
  return 0;
}
