#!/bin/csh
# Pour ecrire les dependances a l'ecran

if( $#argv < 1) then 
  echo ' Usage: mkdepend.csh [-sbase SOPHYABASE] nom_fichier.{cc,c,f}'
  exit -1
endif

set file = $argv[$#argv]
while ( $#argv > 0 )
  if( "$1" == "-sbase" ) then
    setenv SOPHYABASE $2
    shift
  endif
  shift
end

if( ! $?SOPHYABASE ) then
  echo 'ERROR:  define SOPHYABASE or use script arguments'
  exit -2
endif

set inc = $SOPHYABASE/include
set nomsys = `uname`
set ext = $file:e

if( "$ext" == "cc" || "$ext" == "cxx" || "$ext" == "C" || "$ext" == "c" ) then
  gcc -MM -D$nomsys -I$inc $file  \
       | sed -e 's/.*\.o/\$(SOPHYAOBJP)&/'  \
       | sed -e 's?'$inc/'?$(SOPHYAINCP)?g'
else
  echo "extension $ext not reated"
endif

exit 0
