# --------- File Darwin_g++_make.inc -------- 

#  Liste des librariries externes 
SOPEXTLIBS = $(SOPEXTLIBP) $(SOPEXTLIBLIST) -framework Accelerate

#  Chemin et librairie pour PI 
PIINC = -I/usr/include/X11R6 -I/sw/include
PILIBS = -L/sw/lib -lXm -L/usr/X11R6/lib  -lXt -lX11 


#  Flag preprocesseur
CPPFLAGS = -DDarwin -I$(SOPHYAINCP)  $(PIINC)
#  Def compilateur C et flags
CC = cc
CFLAGS = -fno-common -g -fastf -mtune=G4 -fPIC
#  Def compilateur C++ et flags
CXX =  c++
CXXFLAGS = -fno-common -g -fastf -mtune=G4 -fPIC 
#  Compilo fortran
FC = f77
FFLAGS =  
# Pour fabriquer les lib .a
AR = libtool 
ARFLAGS = -static -o 


#  Ordres de compilation
CCOMPILE = $(CC) $(CPPFLAGS) $(CFLAGS) -c 
CXXCOMPILE = $(CXX) $(CPPFLAGS) $(CXXFLAGS) -c 

#  Extension de nom pour les librairies partagees
SLEXT = dylib
#  Fabrication de librairies partagees 
CMDSHLCXX = $(CXX) $(CXXFLAGS) -dynamiclib 


#  Liste de librairie de base, necessaire pour libsophya
SOPBASELIBS = -lpthread -lm -lc -ldl 

# --- Chemin pour l'ensemble les librairies SOPHYA , +ExtLibs, +PI
SOPHYASLBLIST = -L$(SOPHYASLBP) -lsophya  $(SOPBASELIBS)
SOPHYAEXTSLBLIST = -L$(SOPHYASLBP) -lextsophya -lsophya $(SOPEXTLIBS) $(SOPBASELIBS)
SOPHYAALLSLBLIST = -L$(SOPHYASLBP) -lPI -lextsophya -lsophya $(PILIBS) $(SOPEXTLIBS) $(SOPBASELIBS)

#  Commande de link pour creation d'executables
CXXLINK = $(CXX) $(CXXFLAGS) -bind_at_load
