# --------- File Linux_g_make.inc -------- 

#  Liste des librariries externes 
SOPEXTLIBS = $(SOPEXTLIBP) $(SOPEXTLIBLIST) -lg2c

#  Chemin et librairie pour PI 
PIINC = -I/usr/X11R6/include/
PILIBS = -L/usr/X11R6/lib/ -lXm -lXt -lX11 


#  Flag preprocesseur
CPPFLAGS = -DLinux -I$(SOPHYAINCP) -I$(SOPEXTINCP) $(SOPEXTINC) $(PIINC)
#  Def compilateur C et flags
CC = gcc
CFLAGS = -Wall -Wpointer-arith -Wmissing-prototypes -O -g
#  Def compilateur C++ et flags
CXX =  g++
CXXFLAGS = -Wall -Wpointer-arith -Wmissing-prototypes -Wsynth -O -g
#  Compilo fortran
FC = g77
FFLAGS =  
# Pour fabriquer les lib .a
AR = ar
ARFLAGS = -rcs


#  Ordres de compilation
CCOMPILE = $(CC) $(CPPFLAGS) $(CFLAGS) -c 
CXXCOMPILE = $(CXX) $(CPPFLAGS) $(CXXFLAGS) -c 
FCCOMPILE = $(FC) $(FFLAGS) -c 

#  Extension de nom pour les librairies partagees
SLEXT = so
#  Fabrication de librairies partagees 
CMDSHLCXX = $(CXX) $(CXXFLAGS) -shared 


#  Liste de librairie de base, necessaire pour libsophya
SOPBASELIBS = -lpthread -lm -lc -ldl 

# --- Chemin pour l ensemble les librairies SOPHYA , +ExtLibs, +PI
SOPHYASLBLIST = -L$(SOPHYASLBP) -lsophya  $(SOPBASELIBS)
SOPHYAEXTSLBLIST = -L$(SOPHYASLBP) -lextsophya -lsophya $(SOPEXTLIBS) $(SOPBASELIBS)
SOPHYAALLSLBLIST = -L$(SOPHYASLBP) -lPI -lextsophya -lsophya $(PILIBS) $(SOPEXTLIBS) $(SOPBASELIBS)

#  Commande de link pour creation dexecutables
CXXLINK = $(CXX) $(CXXFLAGS)
CLINK = $(CC) $(CFLAGS)

#  Commande de link pour creation de module pouvant etre charge dynamiquement
CXXDLL = $(CXX) $(CXXFLAGS) -shared
