#!/bin/csh
set version = V1.1

if($#argv <= 0)  then
  echo "Give the directory where Sophya should be installed"
  echo "usage: install_from_tar.csh directory_name"
  exit(-1)
endif
set dir = $1
if( ! -e $dir ) then
  echo Directory $dir does not exist
  exit(-1)
endif
touch $dir/toto
if( $status != 0 ) then
  echo Writing impossible in $dir
  exit(-1)
endif
rm -rf $dir/toto $dir/env.csh $dir/$version

################################
#### Creation du fichier env.csh
################################
cat >! $dir/env.csh <<EOF
#!/bin/csh
#  Definition d'environnement SOPHYA sous Linux
#                           R. Ansari   03/2001
#
set sversion = pro
set ostype = Linux
setenv SOPHYACXX g++
if (\$#argv > 0)  then
  if (\$1 == '-h') then
    echo 'Usage: source env.csh [pro/new/old]' 
    echo '  Defines the environment for using SOPHYA '
    echo '  First optional argument defines the library version (pro/new/... Default=pro)'
    exit -1
  endif
  set sversion = \$1
endif

echo ' env.csh : setting environment variables for SOPHYA '

setenv SOPHYABASEREP $dir/$version
setenv EXTLIBDIR  $dir/ExtLibs

if( \$?LD_LIBRARY_PATH ) then 
  setenv LD_LIBRARY_PATH .:\${LD_LIBRARY_PATH}:\${SOPHYABASEREP}/\${ostype}-\${SOPHYACXX}/ShLibs
else 
  setenv LD_LIBRARY_PATH .:\${SOPHYABASEREP}/\${ostype}-\${SOPHYACXX}/ShLibs
endif

set path = (\$path \$SOPHYABASEREP/\${ostype}-\${SOPHYACXX}/Exec)

echo 'SOPHYACXX=    ' \$SOPHYACXX
echo 'SOPHYABASEREP= ' \$SOPHYABASEREP
echo 'EXTLIBDIR=  ' \$EXTLIBDIR
echo 'LD_LIBRARY_PATH= ' \$LD_LIBRARY_PATH 
echo 'PATH= ' \$path

exit 0

EOF
chmod +x $dir/env.csh

#############################
#### extract des fichiers tar
#############################
foreach f ( sophya_src.tar.gz sophya_linux.tar.gz sophya_extlibs_linux.tar.gz)
  if( -e $f ) then
    cp $f $dir/.
    pushd $dir > /dev/null
    tar -xzvf $f
    rm -f $f
    popd > /dev/null
  endif
end

#############################
#### Creation du lien sur pro
#############################
pushd $dir > /dev/null
ln -s -f ./$version ./pro
popd > /dev/null

exit 0
