# --------- File OSF1_cxx_make.inc -------- 

#  Liste des librariries externes 
SOPEXTLIBS = $(SOPEXTLIBP) $(SOPEXTLIBLIST) -lfor

#  Chemin et librairie pour PI 
PIINC = 
PILIBS = -lXm -lXt -lX11 


#  Flag preprocesseur
CPPFLAGS = -DOSF1 -I$(SOPHYAINCP)  $(PIINC)
#  Def compilateur C et flags
CC = cc
CFLAGS = -O -pthread -g1 
#  Def compilateur C++ et flags
CXX =  cxx
CXXFLAGS = -O -pthread -g1 -no_implicit_include
CXXREP =  -ptr $(SOPHYAOBJP)/cxxrep/
#  Compilo fortran
FC = f77
FFLAGS =  
# Pour fabriquer les lib .a
AR = /usr/bin/ar
ARFLAGS = -rcs


#  Ordres de compilation
CCOMPILE = $(CC) $(CPPFLAGS) $(CFLAGS) -c 
CXXCOMPILE = $(CXX) $(CPPFLAGS) $(CXXFLAGS) -c 
CXXCOMPILELIB = $(CXX) $(CPPFLAGS) $(CXXFLAGS) $(CXXREP) -c 
CXXCOMPILEPROG = $(CXX) $(CPPFLAGS) $(CXXFLAGS) $(CXXREP) -c 
FCCOMPILE = $(FC) $(FFLAGS) -c 

#  Extension de nom pour les librairies partagees
SLEXT = so
#  Fabrication de librairies partagees 
CMDSHLCXX = $(CXX) $(CXXFLAGS) $(CXXREP) -shared 


#  Liste de librairie de base, necessaire pour libsophya
SOPBASELIBS = -lpthread -lm 
LIBFORT = -lfor -lFutil -lots -lUfor

# --- Chemin pour l ensemble les librairies SOPHYA , +ExtLibs, +PI
SOPHYASLBLIST = -L$(SOPHYASLBP) -lsophya  $(SOPBASELIBS)
SOPHYAEXTSLBLIST = -L$(SOPHYASLBP) -lextsophya -lsophya $(SOPEXTLIBS) $(SOPBASELIBS)
SOPHYAALLSLBLIST = -L$(SOPHYASLBP) -lPI -lextsophya -lsophya $(PILIBS) $(SOPEXTLIBS) $(SOPBASELIBS)

#  Commande de link pour creation d executables
CXXLINK = $(CXX) $(CXXFLAGS)
CLINK = $(CC) $(CFLAGS)
FCLINK = $(FC) $(FFLAGS)

#  Commande de link pour creation de module pouvant etre charge dynamiquement
CXXDLL = $(CXX) $(CXXFLAGS) -shared
