// Module PI : Peida Interactive  PIBarGraph
// Drawer Y=f(X)      R. Ansari  2004
// (C) LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "sopnamsp.h"
#include "machdefs.h"
#include <stdlib.h>
#include <iostream>
#include "pitxtdrw.h"

// --------------------------------------------------------------------------
// ----------------------------------------------------------
//  Classe de representation d'une serie de lignes de texte
//  eventuellement avec marker ( et bout de ligne <- pas fait) 
// ----------------------------------------------------------
// --------------------------------------------------------------------------

//++
// Class	PITextDrawer
// Lib		PI
// include	pitxtdrw.h
//
//	Classe de representation d'une serie de lignes eventuellement
//	avec un marker 
//
//--
//++
// Links	Parents
// PIDrawer
//--
//++
// Titre	Constructeur
// PITextDrawer::PITextDrawer()
//--


/* --Methode-- */
PITextDrawer::PITextDrawer(bool fgframe)
    : PIDrawer()
{
  fgFrame = fgframe;
  SetName("TextDrw");
} 

/* --Methode-- */
PITextDrawer::~PITextDrawer()
{
}

/* --Methode-- */
int PITextDrawer::AddLine(string const& line_, PIGraphicAtt const& att_)
{
  struct _ldata ld;
  ld.line = line_;
  ld.att = att_;
  mLines.push_back(ld);
  return mLines.size();
}

/* --Methode-- */
int PITextDrawer::AddLine(string const& line)
{
  PIGraphicAtt gatt;
  return AddLine(line, gatt);
}

/* --Methode-- */
void PITextDrawer::UpdateLimits()
{
  double xmin, xmax, ymin, ymax;
  xmin = ymin = 0.; xmax = ymax = 1.;

  PIAxes::ReSizeMinMax(isLogScaleX(),xmin,xmax);
  PIAxes::ReSizeMinMax(isLogScaleY(),ymin,ymax);
  SetLimits(xmin,xmax,ymin,ymax);
  //  SetAxesFlags(kBoxAxes | kExtTicks | kLabels);  Ne pas faire - Reza 05/04->11/99
}


/* --Methode-- */
void PITextDrawer::Draw(PIGraphicUC* g, double xmin, double ymin, double xmax, double ymax)
{
  if (mLines.size() < 1) return;
  PIGraphicAtt siatt = GetGraphicAtt();
  PIGraphicAtt catt;

  PIGrCoord x,y,ym,dx,dy,fa,fd;
  x = 0.05;   y = 0.95;
  for(unsigned int k=0; k<mLines.size(); k++) { 
    catt = siatt;
    catt.UpdateFrom(mLines[k].att);
    SelGraAtt(g);
    if (mLines[k].att.GetMarker() != PI_NotDefMarker) {
      x = 0.03;
      ym = (double)y-(double)(g->GetFontHeight(fa, fd))*0.5;
      g->DrawMarker(x, ym);
      double dxu, dyu;
      double dxpix = g->GetMarkerSize();
      g->DGrC2UC(dxpix, 0, dxu, dyu);
      x = (double)x+dxu+0.02;
    }
    else x = 0.05;
    // Trace des lignes de texte
    g->DrawString(x,y,mLines[k].line.c_str(),PI_VerticalTop);
    y = (double)y-(double)(g->GetFontHeight(fa, fd))*1.1;
  }
  if (fgFrame) {   // Trace de cadre
    SetGraphicAtt(siatt);
    SelGraAtt(g);
    x = y = 0.;
    dx = dy = 1.;
    g->DrawBox(x,y,dx, dy);
  }
}


/* --Methode-- */
int PITextDrawer::DecodeOptionString(vector<string> & opt, bool rmdecopt)
{
  int optsz1 = opt.size();
  if(optsz1<1)  return(0);  
  // On appelle d'abord le decodage de la classe PIDrawer de laquelle
  // on herite. (Pas obligatoire) on decode donc ici les attributs de
  // couleur, fontes ...
  int ndec1 = PIDrawer::DecodeOptionString(opt, rmdecopt);
  if(optsz1-ndec1<1) return(ndec1);  // si tout a ete decode

  vector<string> udopt;  // On gardera ici les options non decodees
  unsigned int k = 0;
  int ndec = opt.size();
  for( k=0; k<opt.size(); k++ ) {
    string opts = opt[k];
    if (opts=="frame") SetFrameFlag(true);
    else if (opts=="noframe") SetFrameFlag(false);
    else {
      // Si option non decode
      ndec--;
      // S'il faut supprimer les options decodees
      if (rmdecopt)  udopt.push_back(opts);
    }
  }  
  // S'il faut supprimer les options decodees, on remplace l'argument opt
  // par le vecteur des options non decodees.
  if (rmdecopt)  opt = udopt;
  return(ndec+ndec1);  
}

/* --Methode-- */
int PITextDrawer::OptionToString(vector<string> & opt) const
{
 PIDrawer::OptionToString(opt);
 if(fgFrame) opt.push_back("frame"); else opt.push_back("noframe");
 return 1;
}

/* --Methode-- */
void PITextDrawer::GetOptionsHelpInfo(string& info)
{
info += " ---- PITextDrawer options help info : \n" ;
info += "  frame,noframe: enable/disable frame drawing\n";
info += " --- + Usual line font color attribute decoding)  \n";
PIDrawer::GetOptionsHelpInfo(info);
return;
}
