// This may look like C code, but it is really -*- C++ -*-
// Classe de fenetre pour gestion d'objet et PPF-In
// Reza      Aout 97 , Juillet,Aout 98, Ete 99
// CEA-DAPNIA      LAL-IN2P3/CNRS

#ifndef PISIADW_H_SEEN
#define PISIADW_H_SEEN

#include <string.h>

#include "pisysdep.h"

#include PIAPP_H
#include PIWIN_H 
#include PIMENU_H 
#include PIOPTMENU_H 
#include PISTDWDG_H 
#include PILIST_H 


class PIStdImgApp;



/* --------------------------------------------------------------------------- */
class ObjMgrWind : public PIWindow {
public :
  ObjMgrWind(PIStdImgApp *par);
  ~ObjMgrWind();
  virtual void  Show();
  virtual void  Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
  inline  void  AddDirectory(const char * dir, int did)
                    { dirlist->AppendItem(dir, 30000+did); }
  inline  void  DelDirectory(int did)
                    { dirlist->Menu()->DeleteItemMsg(30000+did); }
  inline  void  ClearObjList() 
                    { mNitem=0; objlist->DeleteAllItems(); }
  inline  void	AddObj(const char * objn, int oid) 
		    { mNitem++;  objlist->AppendItem(objn, oid); }
  inline  int   GetCurDirId() { return (dirlist->GetValue()-30000); }

  virtual void  UpdateList(int did);
  virtual void	AddObjList(int did, const char * objn, int oid); 
  virtual void	DelObjList(int did, int oid); 

private:
  PIStdImgApp* dap;
  PIOptMenu* dirlist;
  int mNitem;
  PIList* objlist;
  PIButton * mBut[6];
};

/* --------------------------------------------------------------------------- */
class PPInMgrWind :  public PIWindow {
public:
   PPInMgrWind(PIStdImgApp *par);
   ~PPInMgrWind();
   virtual void  Show();
   virtual void  Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
   void SetFile(string flnm);
private:
  PIStdImgApp* dap;
  PIList* objlist;
  PILabel * mLab[2];
  PIButton* mBut[3];
  PInPersist* mPin;
  int tolx, toly, polx, poly;  // Taille et position de  objlist
  int ttx, tty;   // Taille globale par defaut

};
 
#endif
