//  Classe de base pour les conteneurs de PIWdg pour
//  programmes graphiques interactives
//
//                  E.Aubourg , R. Ansari  96 - 98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include <stdio.h>

#include "sopnamsp.h"
#include "picontainergen.h"

//++
// Class	PIContainer
// Lib		PI
// include	picontainergen.h
//
//	Classe conteneur grant un ensemble d'objets "PIWdg". Cette classe 
//	organise la hirarchie des objets "PIWdg" et donc aussi des "PIMsgHandler",
//	contrle la gomtrie des objets "PIWdg" contenus, ainsi que leur 
//	visibilit et activit. Le positionnement initial est controle par
//	un objet *PILayoutMgr* qui peut eventuellement modifier la postion
//	ou la taille de l'objet "PIWdg" ajout. Les attributs d'attachement
//	de l'objet ("PIWdg::SetBinding()") contrle le repositionnement
//	lors du changement de taille du "PIContainer".
//	La classe "PIContainer" est une des 
//	classes de PI qui ont une implementation dpendante du systeme utilis
//	(Mac, XWindow, ...). La classe "PIContainerGen" est la classe qui
//	dfinit l'interface, et ne pas doit tre instancie directement
//	(Mthodes virtuelles pures). Les objets instancis sont de la 
//	classes "PIContainer" et le fichier entte correspondant est "PICONT_H"
//	dfini dans "pisysdep.h"
//--
//++
// Links	Parents
// PIWdg
//--
//++
// Links	Voir aussi
// PILayoutMgr
//--
//++
// Titre	Constructeur
//--
//++
// PIContainer(PIContainerGen *par, const char *nom, int sx, int sy, int px, int py)
//	Cration d'un objet "PIContainer" dans le conteneur parent "par", de
//	taille "sx,sy", se trouvant  la position "px,py" avec le nom "nom".
//	Peut controler la destruction des widgets fils (voir "SetAutoDelChilds()").
//      Le conteneur cr n'est pas visible (actif) par dfaut. Il faut 
//	appeler "Show()".
// long kind()
//	Renvoie le type de la classe de l'objet ("=PIContainerGen::ClassId") pour cette classe.
//--
//++
// Titre	Mthodes
//--
//++
// void SetLayoutMgr(PILayoutMgr* nlay)
//	Permet de changer le gestionnaire de positions ("PILayoutMgr") du conteneur,
//	et donc la stratgie de positionnement des objets "PIWdg" fils. 
//	le LayoutMgr par dfaut n'applique aucune contrainte sur la position
//	ou la taille des objets ajouts.
//	Cette mthode ne peut tre appel que pour un conteneur vide (sans PIWdg fils).
//	Il est conseill de l'appeler juste aprs la cration du "PIContainer"
// PILayoutMgr* GetLayoutMgr()
//	Retourne le gestionnaire de positions/tailles du conteneur.
// void Show()
//	Rend l'objet visible  l'cran. Tous les objets "PIWdg" contenus et qui sont dans 
//	l'tat actif sont visibles.
// void Hide()
//	Rend l'objet et tous les objets contenus invisibles.
// bool Visible()
//	Retourne "true" si l'objet est visible. 
// void  PSPrint(PSFile *psf, int ofx=0, int ofy=0)
//	Appelle la mthode "PSPrint()" pour tous les objets contenus.
// void  SetAutoDelChilds(bool ad = true)
//	Contrle le comportement de l'objet conteneur vis  vis des objets
//	contenus lors de la destruction. si "ad=true", les objets contenus 
//	sont dtruits lors de l'appel du destructeur de l'objet conteneur. 
// int  NbChilds()
//	Retourne le nombre de "PIWdg" contenus.
// PIWdg* GetChild(int n)
//	Retourne le "PIWdg" numro "n" (0..NbChilds()-1) 
//--
//++
// Titre 	Mthodes particulires
//	Les mthodes ci-dessous ne doivent pas tre appeles directement.
//--
//++
// void ChildAdd(PIWdg* child)
//	Mthode qui est appele lors de l'attachement d'un nouvel objet (cration)
//	Appelle la mthode correspondante du "PILayoutMgr"
// void ChildAdd(PIWdg* child)
//	Mthode qui est appele lors du dtachement d'un objet (destruction)
//	Appelle la mthode correspondante du "PILayoutMgr"	
//--


/* --Methode-- */
PIContainerGen::PIContainerGen(PIContainerGen *par, const char *nom, 
                               int sx, int sy, int px, int py)
: PIWdg(par, nom, sx, sy, px, py)  
{
stvis = false;
stfcr = false;
layout = new PILayoutMgr;
layout->SetContainer(this); 
}


/* --Methode-- */
PIContainerGen::~PIContainerGen()
{
delete layout;
}

/* --Methode-- */
void PIContainerGen::SetLayoutMgr(PILayoutMgr* nlay)
{
if (nlay == NULL) return;
if (NbChilds() > 0) {
  fprintf(stderr, "PIContainerGen::SetLayoutMgr()/ Error! Container has childs (N = %d) \n", NbChilds()); 
  return;
  }
delete layout;
layout = nlay;
layout->SetContainer(this); 
}

/* --Methode-- */
void PIContainerGen::PSPrint(PSFile *psf, int ofx, int ofy, double scale_x, double scale_y)
{
int i;
if (!psf)  return;
if (!Visible())  return;
for(i=0; i<NbChilds(); i++)  
  GetChild(i)->PSPrint(psf, ofx+XPos(), ofy+YPos(), scale_x, scale_y); 
return;
}

/* --Methode-- */
void PIContainerGen::Show()
{
Manage();
stvis = true;
if (finishDone) FinishCreate();
}

/* --Methode-- */
void PIContainerGen::Hide()
{
stvis = false;
UnManage();
return;
}

/* --Methode-- */
bool PIContainerGen::Visible()
{
if (Parent())  return(stvis && Parent()->Visible());
else return(stvis && IsVisible());
}

/* --Methode-- */
void PIContainerGen::ChildAdd(PIWdg* child)
{
layout->ChildAdd(child);
// Reza 13/10/98 : il faut que child->FinishCreate() 
// soit appele pour les PIWdg ajoute quand le  container est deja affiche et son FinishCreate() appele
if (stfcr)  child->FinishCreate(); 
return;
}

/* --Methode-- */
void PIContainerGen::ChildDel(PIWdg* child)
{
layout->ChildDel(child);
}

/* --Methode-- */
int PIContainerGen::NbChilds()
{
return(layout->NbChilds());
}

/* --Methode-- */
PIWdg* PIContainerGen::GetChild(int n)
{
return(layout->GetChild(n));
}

/* --Methode-- */
void PIContainerGen::SetAutoDelChilds(bool ad)
{
layout->SetAutoDelChilds(ad) ;
}


/* --Methode-- */
void PIContainerGen::FinishCreate()
{
if (stfcr)  return;
PIWdg::FinishCreate();    
for(int k=0; k<NbChilds(); k++)  GetChild(k)->FinishCreate();
stfcr = true;
}


// ------------------------------------------------------------------
//  Classe PILayoutMgr (Gestionnaire de positions/tailles PIWdg fils
// ------------------------------------------------------------------
//++
// Class	PILayoutMgr
// Lib		PI
// include	picontainergen.h
//
//	Classe de gestionnaire de positions/tailles initiales des "PIWdg"
//	fils pour les "PIContainer".
//	La classe de base n'impose aucune contrainte sur les positions/tailles.
//--
//++
// Links	Voir
// PIContainer
//--

//++
// Titre	Constructeur, mthodes
//--
//++
// PILayoutMgr()
//	Constructeur
// void ChildAdd(PIWdg* child)
//	Mthode appel lors de l'ajout d'un nouveau "PIWdg" au conteneur.
// void ChildDel(PIWdg* child)
//	Mthode appel lors de la suppression d'un "PIWdg"
// int  NbChilds() 
//	Nombre de "PIWdg" grs.
// PIWdg* GetChild(int n)
//	Retourne l'objet "PIWdg" numro "n"
//--

#define NCHALGRP 8

/* --Methode-- */
PILayoutMgr::PILayoutMgr()
{
mNCh = 0;
mACSup = false;   // Pas de Suppression automatique des widgets fils au delete
mPaSup = false;
mChilds = new (PIWdg* [NCHALGRP]);
mMxCh = NCHALGRP;
mCont = NULL;
}

/* --Methode-- */
PILayoutMgr::~PILayoutMgr()
{
mPaSup = true;   // Pour prevenir ChildDel()
if (mACSup)
  for(int i=0; i<mNCh; i++)  delete mChilds[i];
delete[] mChilds;
}

/* --Methode-- */
void PILayoutMgr::ChildAdd(PIWdg* child)
{
if (child == NULL)  return;
if (mNCh == mMxCh)
  {
  PIWdg ** och = mChilds;
  mChilds = new (PIWdg * [mMxCh+NCHALGRP]);
  for(int i=0; i<mNCh; i++)  mChilds[i] = och[i];
  delete[] och;
  mMxCh += NCHALGRP;
  }  
mChilds[mNCh] = child;   mNCh++; 
return;
}

/* --Methode-- */
void PILayoutMgr::ChildDel(PIWdg* child)
{
if (mPaSup) return;  // Ne rien faire si delete initie par Container-parent : Le LayoutMgr lui-meme
if ((child == NULL) || (mNCh < 1))  return;
for(int i=0; i<mNCh; i++)  
  if (mChilds[i] == child)
    {
    mNCh--;
    mChilds[i] = mChilds[mNCh];
    break;
    }
return;
}

