// This may look like C code, but it is really -*- C++ -*-
// Outils de manipulation des PIDrawer  R. Ansari 06/98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIDRWTOOLS_H_SEEN
#define PIDRWTOOLS_H_SEEN

#include "pisysdep.h"
#include PISTDWDG_H
#include PIMENU_H
#include PIOPTMENU_H
#include PIWIN_H
#include PIAPP_H
#include "pibwdggen.h"

// ------ fenetres de dialogue pour modifs options/attributs des Drawers ----------
// --------------------------------------------------------------------------------

class PIDrawer;  // Declaration des objets drawer

// fenetre de gestion interactive des attributs graphique
class PIDrwTools : public PIWindow 
{
public :
  PIDrwTools(PIApplication* par);
  ~PIDrwTools();
  virtual void  Show();

  static void ShowPIDrwTools();
  static void ShowPIDrwTools(PIBaseWdgGen* cbw);
  static void HidePIDrwTools();
  static void SetCurrentBaseWdg(PIBaseWdgGen* cbw);
  static PIBaseWdgGen* GetCurrentBaseWdg();
  static PIDrawer* GetActiveDrawer();
  static void UpdateActiveDrawer();

protected:
  virtual void  UpdateControlsFromDrawer(int numdr);
  virtual void  UpdateAttFromDrawer();
  virtual void  SetGraphicAtt(bool fgref);
  virtual void  Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);

private:
// Pour couleur, fontes, etc 
  PIOptMenu* mOpt[10];
  PIMenu* mCasc[5];
  PILabel* mNlb;
  PILabel* mDrName;
  PIButton* mButdr[2];
  PIButton* mButcf[7];
  int mNDr;
// mButSens  - Pour l'etat de sensibilite des boutons 
// 0 NoBaseDrawer , 1 BaseDrawer - NoDrawer , 2= BaseDrawer+CurDrawer
  int mButSens;  
// ------------------------------------------------------
  static PIBaseWdgGen* mCurBW;
  static PIDrwTools* cwdrwt;
};

// Classe pour le changement interactive des attributs par appel 
// a DecodeOptionString 

class PIDrwOptionStringWindow : public PIWindow 
{
public:
  static void ShowDrwOptionStringWindow(PIDrawer* drw);
  static void RemoveDrwOptionStringWindow(PIDrawer* drw);

  PIDrwOptionStringWindow(PIApplication* par, PIDrawer* drw);
  ~PIDrwOptionStringWindow();
  virtual void  Show();
  inline PIDrawer* GetDrawer() { return mDrw; }

protected:
  virtual void  Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
private:
  PIText* mTxt[2]; 
  PILabel* mLab;
  PIButton* mBut[4];
  PIDrawer* mDrw;
};

//-------------------------------------------------------------------------------------------
// Classe de menu specifique de manipulation interactive des drawers attaches a un PIBaseWdg
//-------------------------------------------------------------------------------------------
class PIDrwPosSizeEvH;  // Event Handler pour le deplacement/resize des drawers 
class PIDrwSelectEvH;   // Event Handler pour la selection interactive des drawers 

class PIDrwMgrMenu : public PIMenu {
public:
                  PIDrwMgrMenu(PIBaseWdg* bwdg, bool fgxor=true);
  virtual         ~PIDrwMgrMenu();
  virtual void    Process(PIMessage msg, PIMsgHandler* sender, void* data=NULL);
protected:
  PIMenu*  mListDrw;
  PIBaseWdg* mBWdg;
  bool mFgxor;
  PIDrwPosSizeEvH* mEvH;
  PIDrwSelectEvH* mSEvH;
};

#endif
