#include "fitsswapper.h"
#include "sopnamsp.h"
#include <stdio.h>
#include <iostream>


template <class T> 
FITSDataSwapper<T>::FITSDataSwapper()
{
  SetInStream(NULL, 0); 
  SetOutStream(NULL, 0);
}

template <class T> 
FITSDataSwapper<T>::FITSDataSwapper(fitsfile * is, int coli, fitsfile * os, int colo)
{
  SetInStream(is, coli);
  if (os == NULL) SetOutStream(is, coli);
  else 	SetOutStream(os, colo);
}

template <class T> 
void FITSDataSwapper<T>::SetInStream(fitsfile * is, int col)
{
  fitsis = is;
  colis = col;
  hduis = 0;
  int status=0, hdutype=0;
  if (is != NULL)  { 
    if ( fits_get_hdu_num(fitsis, &hduis) <= 0) 
      throw IOExc("FITSDataSwapper<T>::SetInStream() fits_get_hdu_num Error");
    if (fits_get_hdu_type(fitsis, &hdutype, &status)) {
      fits_report_error(stdout,status); fflush(stdout);
      throw IOExc("FITSDataSwapper<T>::SetInStream()  fits_get_hdu_type Error");
    }
    //    cout << "DBG-SetInStream() :  hduis= " << hduis 
    //	 << " hdutype=" << hdutype << " BINARY_TBL= " << BINARY_TBL << endl;
    if ( (hdutype != ASCII_TBL) && (hdutype != BINARY_TBL) )
      throw IOExc("FITSDataSwapper<T>::SetInStream() current HDU not of BINARY_TBL or ASCII_TBL type");
  }
}

template <class T> 
void FITSDataSwapper<T>::SetOutStream(fitsfile * os, int col)
{
  fitsos = os;
  colos = col;
  hduos = 0;
  rowos = 0;
  int status=0, hdutype=0;
  if (os != NULL)  { 
    if ( fits_get_hdu_num(fitsos, &hduos) <= 0 ) 
      throw IOExc("FITSDataSwapper<T>::SetOutStream() fits_get_hdu_num Error");
    if (fits_get_hdu_type(fitsos, &hdutype, &status)) {
      fits_report_error(stdout,status); fflush(stdout);
      throw IOExc("FITSDataSwapper<T>::SetOutStream()  fits_get_hdu_type Error");
    }
    //    cout << "DBG-SetOutStream() :  hduos= " << hduos 
    //	 << " hdutype=" << hdutype << " BINARY_TBL= " << BINARY_TBL << endl;
    if ( (hdutype != ASCII_TBL) && (hdutype != BINARY_TBL) )
      throw IOExc("FITSDataSwapper<T>::SetOutStream() current HDU not of BINARY_TBL or ASCII_TBL type");
  }
}

template <class T> 
FITSDataSwapper<T>& FITSDataSwapper<T>::operator = (FITSDataSwapper<T> const & a)
{
  fitsos = a.fitsos;
  colos = a.colos;
  hduos = a.hduos;
  rowos = a.rowos;
  fitsis = a.fitsis;
  colis = a.colis;
  hduis = a.hduis;
  return *this;
}


static inline int _ConvertToFitsDataType(const r_8 * d) { return TDOUBLE; }
static inline int _ConvertToFitsDataType(const r_4 * d) { return TFLOAT; }
static inline int _ConvertToFitsDataType(const uint_2 * d) { return TUSHORT; }
static inline int _ConvertToFitsDataType(const int_2 * d) { return TSHORT; }
static inline int _ConvertToFitsDataType(const int_4 * d) { return (sizeof(long)==4) ? TLONG: TINT; }
#ifdef TLONGLONG
static inline int _ConvertToFitsDataType(const int_8 * d) { return TLONGLONG; }
#else
static inline int _ConvertToFitsDataType(const int_8 * d) { throw NotAvailableOperation("FITSDataSwapper<int_8> ; Unsupported data type ")}
#endif

template <class T> 
int_8 FITSDataSwapper<T>::WriteToSwap(const T * d, size_t sz, int_8 idx, int_8 oswp, bool osw)
{
  if (fitsos == NULL) throw IOExc("FITSDataSwapper<T>::WriteToSwap() null output stream pointer (fitsos)" );
  int hdutype=0, status=0;
  if(fits_movabs_hdu(fitsos,hduos,&hdutype,&status)) {
    fits_report_error(stdout,status); fflush(stdout);
    throw IOExc("FITSDataSwapper<T>::WriteToSwap() fits_movabs_hdu  Error");
  }
  int ftype = _ConvertToFitsDataType(d);
  long row;
  if (osw)  row = oswp;
  else row = rowos;  
  T * ncd = const_cast<T *>(d);
  if( fits_write_col(fitsos, ftype, colos+1, row+1, 1, sz, ncd, &status) ) {
    fits_report_error(stdout,status); fflush(stdout);
    throw IOExc("FITSDataSwapper<T>::WriteToSwap()  fits_write_col  Error");
  }
  if (!osw)  rowos += sz;  // On met a jour la position d'ecriture courante si pas de reecriture
  return row;
}

template <class T> 
void FITSDataSwapper<T>::ReadFromSwap(int_8 idx, int_8 swp, T* d, size_t sz)
{
  if (fitsis == NULL) throw IOExc("FITSDataSwapper<T>::ReadFromSwap() null input stream pointer (fitsis)" );
  int hdutype=0, status=0;
  if(fits_movabs_hdu(fitsis,hduos,&hdutype,&status)) {
      fits_report_error(stdout,status); fflush(stdout);
      throw IOExc("FITSDataSwapper<T>::ReadFromSwap() fits_movabs_hdu  Error");
  }
  int ftype = _ConvertToFitsDataType(d);
  if( fits_read_col(fitsis, ftype, colis+1, swp+1, 1, sz, NULL, d, NULL, &status) ) {
    fits_report_error(stdout,status); fflush(stdout);
    throw IOExc("FITSDataSwapper<T>::ReadFromSwap()  fits_read_col  Error");
  }
  return;
}


///////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////
#ifdef __CXX_PRAGMA_TEMPLATES__

#pragma define_template FITSDataSwapper<uint_2>
#pragma define_template FITSDataSwapper<int_2>
#pragma define_template FITSDataSwapper<int_4>
#pragma define_template FITSDataSwapper<int_8>
#pragma define_template FITSDataSwapper<r_4>
#pragma define_template FITSDataSwapper<r_8>
#endif

#if defined(ANSI_TEMPLATES) || defined(GNU_TEMPLATES)
template class FITSDataSwapper<uint_2>;
template class FITSDataSwapper<int_2>;
template class FITSDataSwapper<int_4>;
template class FITSDataSwapper<int_8>;
template class FITSDataSwapper<r_4>;
template class FITSDataSwapper<r_8>;
#endif
