// This may look like C code, but it is really -*- C++ -*-
// Gestion de block de donnees swapable
//          C. Magneville R. Ansari  Mai 2005
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA
#ifndef FITSSWAPPER_H
#define FITSSWAPPER_H


#include "machdefs.h"
#include "swsegdb.h"
#include "FitsIO/fitsio.h"

namespace SOPHYA {
/*!
  \class SOPHYA::FITSDataSwapper
  \ingroup FitsIOServer
  Implementation of SOPHYA::DataSwapperInterface interface on FITS streams 
  (fitsfile *) to be used with SOPHYA::SwSegDataBlock classes.
*/

template <class T> 
class FITSDataSwapper : public DataSwapperInterface<T> {
public:
  FITSDataSwapper();
  FITSDataSwapper(fitsfile * is, int coli, fitsfile * os=NULL, int colo=0); 

  inline fitsfile * InStream() { return *fitsis; }
  inline fitsfile * OutStream() { return *fitsos; }
  void SetInStream(fitsfile * is, int col);
  void SetOutStream(fitsfile * os, int col);

  // Operateur = , on recopie les pointeurs des streams 
  FITSDataSwapper<T>& operator = (FITSDataSwapper<T> const & a); 

  virtual int_8 WriteToSwap(const T * d, size_t sz, int_8 idx, int_8 oswp=0, bool osw=false);
  virtual void  ReadFromSwap(int_8 idx, int_8 swp, T* d, size_t sz);

protected:
  fitsfile * fitsos;
  int colos, hduos;
  long rowos;
  fitsfile * fitsis;
  int colis, hduis;
};

} // Fin du namespace

#endif
