#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream>

#include "sopnamsp.h"
#include "histinit.h"
#include "dvlist.h"
#include "datatable.h"
#include "swppfdtable.h"
#include "fabtwriter.h"
#include "fabtcolread.h"
#include "fitsswapper.h"

void test_fdtable() ; 

int main(int narg, char *arg[])
{
  SophyaInit();
  try {
    /*
    if (*arg[1] == 'd')  test_dvl();
    else if (*arg[1] == 'n')  test_ntuple();
    //    else if (*arg[1] == 'x')  test_xntuple();
    else if (*arg[1] == 'X')  test_Xntuple();
    */
    test_fdtable();
  }
  catch(PThrowable exc ) {
    cerr << "tnt-main() , Catched exception: \n" << exc.Msg() << endl;
  }
  catch(std::exception ex) {
    cerr << "tnt-main() , Catched exception ! " << (string)(ex.what()) << endl;
  }
  catch(...) {
    cerr << "tnt-main() , Catched ... ! " << endl;
  }
}


void test_fdtable() 
{
  cout << "======= test_fdtable:  simple DataTable+FITS test ======= " << endl;
    int SWSEGSZ = 4;
    vector<int_8> tags;
    {
      cout << " Creation FITSDataSwapper<double> swout(so) avec swseg.fits " << endl;
      FitsABTWriter so("!swseg.fits", BINARY_TBL, 0);
      so.SetExtName("SwapMyExt");
      int col = so.AddCol("SwapColD", NULL, "unit1", TDOUBLE);  
      so.Write(col, 0, 88888);
      so.Print();
      cout << " ---- Appel a FITSDataSwapper<double> --- " << endl;
      FITSDataSwapper<double> swout(so.GetFitsPtr(),0 );
      SwSegDataBlock<double> swsd(swout, SWSEGSZ, 3);
      double * fp = swsd.GetSegment(0);
      fp[0] = 6.54321;   fp[1] = 65.4321;  fp[2] = 654.321;  fp[3] = 6543.21;
      fp = swsd.GetSegment(1);
      fp[0] = 2.56789;   fp[1] = 25.6789;  fp[2] = 256.789;  fp[3] = 2567.89;
      fp = swsd.GetSegment(2);
      fp[0] = 12.567;   fp[1] = 225.67;  fp[2] = 3256.7;  fp[3] = 42567.;
      tags = swsd.GetSwapPosTagTable();
      cout << " Les pos-tags du FITS NbTag=" << tags.size() << endl;
      for (int kk=0; kk<tags.size(); kk++)  cout << tags[kk] << " ," ;
      cout << endl;
    }
    {
      cout << "6/ Creation PPFDataSwapper<float> avec lecture depuis swseg.ppf " << endl;
      FitsOpenFile si("swseg.fits");
      si.MoveToFirst(BINARY_TBL);
      FITSDataSwapper<double> swin(si.GetFitsPtr(), 0);
      SwSegDataBlock<double> swsd(swin, tags, SWSEGSZ);
      cout <<"7/ Recopie ds SegDataBlock<float> depuis SwSegDataBlock<float> et print" << endl;
      SegDataBlock<double> segd;
      segd = swsd;
      segd.Print(cout, 4, "  ");
    }
    
  cout << "============ FIN  test_fdtable ======== ======= " << endl;  
}




